package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.lakeformation.model.primitives.{LFTagKey, CatalogIdString}
import scala.jdk.CollectionConverters._
final case class GetLfTagRequest(
    catalogId: Optional[CatalogIdString] = Optional.Absent,
    tagKey: LFTagKey
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.GetLfTagRequest = {
    import GetLfTagRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.GetLfTagRequest
      .builder()
      .optionallyWith(
        catalogId.map(value => CatalogIdString.unwrap(value): java.lang.String)
      )(_.catalogId)
      .tagKey(LFTagKey.unwrap(tagKey): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.GetLfTagRequest.ReadOnly =
    zio.aws.lakeformation.model.GetLfTagRequest.wrap(buildAwsValue())
}
object GetLfTagRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.GetLfTagRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.GetLfTagRequest =
      zio.aws.lakeformation.model
        .GetLfTagRequest(catalogId.map(value => value), tagKey)
    def catalogId: Optional[CatalogIdString]
    def tagKey: LFTagKey
    def getCatalogId: ZIO[Any, AwsError, CatalogIdString] =
      AwsError.unwrapOptionField("catalogId", catalogId)
    def getTagKey: ZIO[Any, Nothing, LFTagKey] = ZIO.succeed(tagKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.GetLfTagRequest
  ) extends zio.aws.lakeformation.model.GetLfTagRequest.ReadOnly {
    override val catalogId: Optional[CatalogIdString] = zio.aws.core.internal
      .optionalFromNullable(impl.catalogId())
      .map(value =>
        zio.aws.lakeformation.model.primitives.CatalogIdString(value)
      )
    override val tagKey: LFTagKey =
      zio.aws.lakeformation.model.primitives.LFTagKey(impl.tagKey())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.GetLfTagRequest
  ): zio.aws.lakeformation.model.GetLfTagRequest.ReadOnly = new Wrapper(impl)
}
