package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetDataCellsFilterResponse(
    dataCellsFilter: Optional[zio.aws.lakeformation.model.DataCellsFilter] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.GetDataCellsFilterResponse = {
    import GetDataCellsFilterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.GetDataCellsFilterResponse
      .builder()
      .optionallyWith(dataCellsFilter.map(value => value.buildAwsValue()))(
        _.dataCellsFilter
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.GetDataCellsFilterResponse.ReadOnly =
    zio.aws.lakeformation.model.GetDataCellsFilterResponse.wrap(buildAwsValue())
}
object GetDataCellsFilterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.GetDataCellsFilterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.GetDataCellsFilterResponse =
      zio.aws.lakeformation.model.GetDataCellsFilterResponse(
        dataCellsFilter.map(value => value.asEditable)
      )
    def dataCellsFilter
        : Optional[zio.aws.lakeformation.model.DataCellsFilter.ReadOnly]
    def getDataCellsFilter: ZIO[
      Any,
      AwsError,
      zio.aws.lakeformation.model.DataCellsFilter.ReadOnly
    ] = AwsError.unwrapOptionField("dataCellsFilter", dataCellsFilter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.GetDataCellsFilterResponse
  ) extends zio.aws.lakeformation.model.GetDataCellsFilterResponse.ReadOnly {
    override val dataCellsFilter
        : Optional[zio.aws.lakeformation.model.DataCellsFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataCellsFilter())
        .map(value => zio.aws.lakeformation.model.DataCellsFilter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.GetDataCellsFilterResponse
  ): zio.aws.lakeformation.model.GetDataCellsFilterResponse.ReadOnly =
    new Wrapper(impl)
}
