package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.lakeformation.model.primitives.{
  VersionString,
  NameString,
  CatalogIdString
}
import scala.jdk.CollectionConverters._
final case class DataCellsFilter(
    tableCatalogId: CatalogIdString,
    databaseName: NameString,
    tableName: NameString,
    name: NameString,
    rowFilter: Optional[zio.aws.lakeformation.model.RowFilter] =
      Optional.Absent,
    columnNames: Optional[Iterable[NameString]] = Optional.Absent,
    columnWildcard: Optional[zio.aws.lakeformation.model.ColumnWildcard] =
      Optional.Absent,
    versionId: Optional[VersionString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.DataCellsFilter = {
    import DataCellsFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.DataCellsFilter
      .builder()
      .tableCatalogId(CatalogIdString.unwrap(tableCatalogId): java.lang.String)
      .databaseName(NameString.unwrap(databaseName): java.lang.String)
      .tableName(NameString.unwrap(tableName): java.lang.String)
      .name(NameString.unwrap(name): java.lang.String)
      .optionallyWith(rowFilter.map(value => value.buildAwsValue()))(
        _.rowFilter
      )
      .optionallyWith(
        columnNames.map(value =>
          value.map { item =>
            NameString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.columnNames)
      .optionallyWith(columnWildcard.map(value => value.buildAwsValue()))(
        _.columnWildcard
      )
      .optionallyWith(
        versionId.map(value => VersionString.unwrap(value): java.lang.String)
      )(_.versionId)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.DataCellsFilter.ReadOnly =
    zio.aws.lakeformation.model.DataCellsFilter.wrap(buildAwsValue())
}
object DataCellsFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.DataCellsFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.DataCellsFilter =
      zio.aws.lakeformation.model.DataCellsFilter(
        tableCatalogId,
        databaseName,
        tableName,
        name,
        rowFilter.map(value => value.asEditable),
        columnNames.map(value => value),
        columnWildcard.map(value => value.asEditable),
        versionId.map(value => value)
      )
    def tableCatalogId: CatalogIdString
    def databaseName: NameString
    def tableName: NameString
    def name: NameString
    def rowFilter: Optional[zio.aws.lakeformation.model.RowFilter.ReadOnly]
    def columnNames: Optional[List[NameString]]
    def columnWildcard
        : Optional[zio.aws.lakeformation.model.ColumnWildcard.ReadOnly]
    def versionId: Optional[VersionString]
    def getTableCatalogId: ZIO[Any, Nothing, CatalogIdString] =
      ZIO.succeed(tableCatalogId)
    def getDatabaseName: ZIO[Any, Nothing, NameString] =
      ZIO.succeed(databaseName)
    def getTableName: ZIO[Any, Nothing, NameString] = ZIO.succeed(tableName)
    def getName: ZIO[Any, Nothing, NameString] = ZIO.succeed(name)
    def getRowFilter
        : ZIO[Any, AwsError, zio.aws.lakeformation.model.RowFilter.ReadOnly] =
      AwsError.unwrapOptionField("rowFilter", rowFilter)
    def getColumnNames: ZIO[Any, AwsError, List[NameString]] =
      AwsError.unwrapOptionField("columnNames", columnNames)
    def getColumnWildcard: ZIO[
      Any,
      AwsError,
      zio.aws.lakeformation.model.ColumnWildcard.ReadOnly
    ] = AwsError.unwrapOptionField("columnWildcard", columnWildcard)
    def getVersionId: ZIO[Any, AwsError, VersionString] =
      AwsError.unwrapOptionField("versionId", versionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.DataCellsFilter
  ) extends zio.aws.lakeformation.model.DataCellsFilter.ReadOnly {
    override val tableCatalogId: CatalogIdString =
      zio.aws.lakeformation.model.primitives
        .CatalogIdString(impl.tableCatalogId())
    override val databaseName: NameString =
      zio.aws.lakeformation.model.primitives.NameString(impl.databaseName())
    override val tableName: NameString =
      zio.aws.lakeformation.model.primitives.NameString(impl.tableName())
    override val name: NameString =
      zio.aws.lakeformation.model.primitives.NameString(impl.name())
    override val rowFilter
        : Optional[zio.aws.lakeformation.model.RowFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rowFilter())
        .map(value => zio.aws.lakeformation.model.RowFilter.wrap(value))
    override val columnNames: Optional[List[NameString]] = zio.aws.core.internal
      .optionalFromNullable(impl.columnNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lakeformation.model.primitives.NameString(item)
        }.toList
      )
    override val columnWildcard
        : Optional[zio.aws.lakeformation.model.ColumnWildcard.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.columnWildcard())
        .map(value => zio.aws.lakeformation.model.ColumnWildcard.wrap(value))
    override val versionId: Optional[VersionString] = zio.aws.core.internal
      .optionalFromNullable(impl.versionId())
      .map(value => zio.aws.lakeformation.model.primitives.VersionString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.DataCellsFilter
  ): zio.aws.lakeformation.model.DataCellsFilter.ReadOnly = new Wrapper(impl)
}
