package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.lakeformation.model.primitives.AuditContextString
import scala.jdk.CollectionConverters._
final case class AuditContext(
    additionalAuditContext: Optional[AuditContextString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.AuditContext = {
    import AuditContext.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.AuditContext
      .builder()
      .optionallyWith(
        additionalAuditContext.map(value =>
          AuditContextString.unwrap(value): java.lang.String
        )
      )(_.additionalAuditContext)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.AuditContext.ReadOnly =
    zio.aws.lakeformation.model.AuditContext.wrap(buildAwsValue())
}
object AuditContext {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.AuditContext
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.AuditContext =
      zio.aws.lakeformation.model
        .AuditContext(additionalAuditContext.map(value => value))
    def additionalAuditContext: Optional[AuditContextString]
    def getAdditionalAuditContext: ZIO[Any, AwsError, AuditContextString] =
      AwsError.unwrapOptionField(
        "additionalAuditContext",
        additionalAuditContext
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.AuditContext
  ) extends zio.aws.lakeformation.model.AuditContext.ReadOnly {
    override val additionalAuditContext: Optional[AuditContextString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.additionalAuditContext())
        .map(value =>
          zio.aws.lakeformation.model.primitives.AuditContextString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.AuditContext
  ): zio.aws.lakeformation.model.AuditContext.ReadOnly = new Wrapper(impl)
}
