package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.lakeformation.model.primitives.{
  TransactionIdString,
  NameString,
  CatalogIdString
}
import scala.jdk.CollectionConverters._
final case class DeleteObjectsOnCancelRequest(
    catalogId: Optional[CatalogIdString] = Optional.Absent,
    databaseName: NameString,
    tableName: NameString,
    transactionId: TransactionIdString,
    objects: Iterable[zio.aws.lakeformation.model.VirtualObject]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.DeleteObjectsOnCancelRequest = {
    import DeleteObjectsOnCancelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.DeleteObjectsOnCancelRequest
      .builder()
      .optionallyWith(
        catalogId.map(value => CatalogIdString.unwrap(value): java.lang.String)
      )(_.catalogId)
      .databaseName(NameString.unwrap(databaseName): java.lang.String)
      .tableName(NameString.unwrap(tableName): java.lang.String)
      .transactionId(
        TransactionIdString.unwrap(transactionId): java.lang.String
      )
      .objects(objects.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.DeleteObjectsOnCancelRequest.ReadOnly =
    zio.aws.lakeformation.model.DeleteObjectsOnCancelRequest
      .wrap(buildAwsValue())
}
object DeleteObjectsOnCancelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.DeleteObjectsOnCancelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.DeleteObjectsOnCancelRequest =
      zio.aws.lakeformation.model.DeleteObjectsOnCancelRequest(
        catalogId.map(value => value),
        databaseName,
        tableName,
        transactionId,
        objects.map { item =>
          item.asEditable
        }
      )
    def catalogId: Optional[CatalogIdString]
    def databaseName: NameString
    def tableName: NameString
    def transactionId: TransactionIdString
    def objects: List[zio.aws.lakeformation.model.VirtualObject.ReadOnly]
    def getCatalogId: ZIO[Any, AwsError, CatalogIdString] =
      AwsError.unwrapOptionField("catalogId", catalogId)
    def getDatabaseName: ZIO[Any, Nothing, NameString] =
      ZIO.succeed(databaseName)
    def getTableName: ZIO[Any, Nothing, NameString] = ZIO.succeed(tableName)
    def getTransactionId: ZIO[Any, Nothing, TransactionIdString] =
      ZIO.succeed(transactionId)
    def getObjects: ZIO[Any, Nothing, List[
      zio.aws.lakeformation.model.VirtualObject.ReadOnly
    ]] = ZIO.succeed(objects)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.DeleteObjectsOnCancelRequest
  ) extends zio.aws.lakeformation.model.DeleteObjectsOnCancelRequest.ReadOnly {
    override val catalogId: Optional[CatalogIdString] = zio.aws.core.internal
      .optionalFromNullable(impl.catalogId())
      .map(value =>
        zio.aws.lakeformation.model.primitives.CatalogIdString(value)
      )
    override val databaseName: NameString =
      zio.aws.lakeformation.model.primitives.NameString(impl.databaseName())
    override val tableName: NameString =
      zio.aws.lakeformation.model.primitives.NameString(impl.tableName())
    override val transactionId: TransactionIdString =
      zio.aws.lakeformation.model.primitives
        .TransactionIdString(impl.transactionId())
    override val objects
        : List[zio.aws.lakeformation.model.VirtualObject.ReadOnly] = impl
      .objects()
      .asScala
      .map { item =>
        zio.aws.lakeformation.model.VirtualObject.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.DeleteObjectsOnCancelRequest
  ): zio.aws.lakeformation.model.DeleteObjectsOnCancelRequest.ReadOnly =
    new Wrapper(impl)
}
