package zio.aws.lakeformation.model
import scala.jdk.CollectionConverters._
sealed trait TransactionType {
  def unwrap
      : software.amazon.awssdk.services.lakeformation.model.TransactionType
}
object TransactionType {
  def wrap(
      value: software.amazon.awssdk.services.lakeformation.model.TransactionType
  ): zio.aws.lakeformation.model.TransactionType = value match {
    case software.amazon.awssdk.services.lakeformation.model.TransactionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lakeformation.model.TransactionType.READ_AND_WRITE =>
      val r = READ_AND_WRITE
      r
    case software.amazon.awssdk.services.lakeformation.model.TransactionType.READ_ONLY =>
      val r = READ_ONLY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lakeformation.model.TransactionType {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.TransactionType =
      software.amazon.awssdk.services.lakeformation.model.TransactionType.UNKNOWN_TO_SDK_VERSION
  }
  case object READ_AND_WRITE
      extends zio.aws.lakeformation.model.TransactionType {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.TransactionType =
      software.amazon.awssdk.services.lakeformation.model.TransactionType.READ_AND_WRITE
  }
  case object READ_ONLY extends zio.aws.lakeformation.model.TransactionType {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.TransactionType =
      software.amazon.awssdk.services.lakeformation.model.TransactionType.READ_ONLY
  }
}
