package zio.aws.lakeformation.model
import zio.aws.lakeformation.model.primitives.{
  TrueFalseString,
  PageSize,
  Token,
  CatalogIdString
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListPermissionsRequest(
    catalogId: Optional[CatalogIdString] = Optional.Absent,
    principal: Optional[zio.aws.lakeformation.model.DataLakePrincipal] =
      Optional.Absent,
    resourceType: Optional[zio.aws.lakeformation.model.DataLakeResourceType] =
      Optional.Absent,
    resource: Optional[zio.aws.lakeformation.model.Resource] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent,
    maxResults: Optional[PageSize] = Optional.Absent,
    includeRelated: Optional[TrueFalseString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.ListPermissionsRequest = {
    import ListPermissionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.ListPermissionsRequest
      .builder()
      .optionallyWith(
        catalogId.map(value => CatalogIdString.unwrap(value): java.lang.String)
      )(_.catalogId)
      .optionallyWith(principal.map(value => value.buildAwsValue()))(
        _.principal
      )
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(resource.map(value => value.buildAwsValue()))(_.resource)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(maxResults.map(value => PageSize.unwrap(value): Integer))(
        _.maxResults
      )
      .optionallyWith(
        includeRelated.map(value =>
          TrueFalseString.unwrap(value): java.lang.String
        )
      )(_.includeRelated)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.ListPermissionsRequest.ReadOnly =
    zio.aws.lakeformation.model.ListPermissionsRequest.wrap(buildAwsValue())
}
object ListPermissionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.ListPermissionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.ListPermissionsRequest =
      zio.aws.lakeformation.model.ListPermissionsRequest(
        catalogId.map(value => value),
        principal.map(value => value.asEditable),
        resourceType.map(value => value),
        resource.map(value => value.asEditable),
        nextToken.map(value => value),
        maxResults.map(value => value),
        includeRelated.map(value => value)
      )
    def catalogId: Optional[CatalogIdString]
    def principal
        : Optional[zio.aws.lakeformation.model.DataLakePrincipal.ReadOnly]
    def resourceType: Optional[zio.aws.lakeformation.model.DataLakeResourceType]
    def resource: Optional[zio.aws.lakeformation.model.Resource.ReadOnly]
    def nextToken: Optional[Token]
    def maxResults: Optional[PageSize]
    def includeRelated: Optional[TrueFalseString]
    def getCatalogId: ZIO[Any, AwsError, CatalogIdString] =
      AwsError.unwrapOptionField("catalogId", catalogId)
    def getPrincipal: ZIO[
      Any,
      AwsError,
      zio.aws.lakeformation.model.DataLakePrincipal.ReadOnly
    ] = AwsError.unwrapOptionField("principal", principal)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.lakeformation.model.DataLakeResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getResource
        : ZIO[Any, AwsError, zio.aws.lakeformation.model.Resource.ReadOnly] =
      AwsError.unwrapOptionField("resource", resource)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getIncludeRelated: ZIO[Any, AwsError, TrueFalseString] =
      AwsError.unwrapOptionField("includeRelated", includeRelated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.ListPermissionsRequest
  ) extends zio.aws.lakeformation.model.ListPermissionsRequest.ReadOnly {
    override val catalogId: Optional[CatalogIdString] = zio.aws.core.internal
      .optionalFromNullable(impl.catalogId())
      .map(value =>
        zio.aws.lakeformation.model.primitives.CatalogIdString(value)
      )
    override val principal
        : Optional[zio.aws.lakeformation.model.DataLakePrincipal.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.principal())
        .map(value => zio.aws.lakeformation.model.DataLakePrincipal.wrap(value))
    override val resourceType
        : Optional[zio.aws.lakeformation.model.DataLakeResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value =>
          zio.aws.lakeformation.model.DataLakeResourceType.wrap(value)
        )
    override val resource
        : Optional[zio.aws.lakeformation.model.Resource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resource())
        .map(value => zio.aws.lakeformation.model.Resource.wrap(value))
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lakeformation.model.primitives.Token(value))
    override val maxResults: Optional[PageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.lakeformation.model.primitives.PageSize(value))
    override val includeRelated: Optional[TrueFalseString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includeRelated())
        .map(value =>
          zio.aws.lakeformation.model.primitives.TrueFalseString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.ListPermissionsRequest
  ): zio.aws.lakeformation.model.ListPermissionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
