package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.lakeformation.model.primitives.TransactionIdString
import scala.jdk.CollectionConverters._
final case class ExtendTransactionRequest(
    transactionId: Optional[TransactionIdString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.ExtendTransactionRequest = {
    import ExtendTransactionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.ExtendTransactionRequest
      .builder()
      .optionallyWith(
        transactionId.map(value =>
          TransactionIdString.unwrap(value): java.lang.String
        )
      )(_.transactionId)
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.ExtendTransactionRequest.ReadOnly =
    zio.aws.lakeformation.model.ExtendTransactionRequest.wrap(buildAwsValue())
}
object ExtendTransactionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.ExtendTransactionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.ExtendTransactionRequest =
      zio.aws.lakeformation.model
        .ExtendTransactionRequest(transactionId.map(value => value))
    def transactionId: Optional[TransactionIdString]
    def getTransactionId: ZIO[Any, AwsError, TransactionIdString] =
      AwsError.unwrapOptionField("transactionId", transactionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.ExtendTransactionRequest
  ) extends zio.aws.lakeformation.model.ExtendTransactionRequest.ReadOnly {
    override val transactionId: Optional[TransactionIdString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transactionId())
        .map(value =>
          zio.aws.lakeformation.model.primitives.TransactionIdString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.ExtendTransactionRequest
  ): zio.aws.lakeformation.model.ExtendTransactionRequest.ReadOnly =
    new Wrapper(impl)
}
