package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.lakeformation.model.primitives.TransactionIdString
import scala.jdk.CollectionConverters._
final case class CancelTransactionRequest(transactionId: TransactionIdString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.CancelTransactionRequest = {
    import CancelTransactionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.CancelTransactionRequest
      .builder()
      .transactionId(
        TransactionIdString.unwrap(transactionId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.CancelTransactionRequest.ReadOnly =
    zio.aws.lakeformation.model.CancelTransactionRequest.wrap(buildAwsValue())
}
object CancelTransactionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.CancelTransactionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.CancelTransactionRequest =
      zio.aws.lakeformation.model.CancelTransactionRequest(transactionId)
    def transactionId: TransactionIdString
    def getTransactionId: ZIO[Any, Nothing, TransactionIdString] =
      ZIO.succeed(transactionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.CancelTransactionRequest
  ) extends zio.aws.lakeformation.model.CancelTransactionRequest.ReadOnly {
    override val transactionId: TransactionIdString =
      zio.aws.lakeformation.model.primitives
        .TransactionIdString(impl.transactionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.CancelTransactionRequest
  ): zio.aws.lakeformation.model.CancelTransactionRequest.ReadOnly =
    new Wrapper(impl)
}
