package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetDataLakeSettingsResponse(
    dataLakeSettings: Optional[zio.aws.lakeformation.model.DataLakeSettings] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.GetDataLakeSettingsResponse = {
    import GetDataLakeSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.GetDataLakeSettingsResponse
      .builder()
      .optionallyWith(dataLakeSettings.map(value => value.buildAwsValue()))(
        _.dataLakeSettings
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.GetDataLakeSettingsResponse.ReadOnly =
    zio.aws.lakeformation.model.GetDataLakeSettingsResponse
      .wrap(buildAwsValue())
}
object GetDataLakeSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.GetDataLakeSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.GetDataLakeSettingsResponse =
      zio.aws.lakeformation.model.GetDataLakeSettingsResponse(
        dataLakeSettings.map(value => value.asEditable)
      )
    def dataLakeSettings
        : Optional[zio.aws.lakeformation.model.DataLakeSettings.ReadOnly]
    def getDataLakeSettings: ZIO[
      Any,
      AwsError,
      zio.aws.lakeformation.model.DataLakeSettings.ReadOnly
    ] = AwsError.unwrapOptionField("dataLakeSettings", dataLakeSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.GetDataLakeSettingsResponse
  ) extends zio.aws.lakeformation.model.GetDataLakeSettingsResponse.ReadOnly {
    override val dataLakeSettings
        : Optional[zio.aws.lakeformation.model.DataLakeSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataLakeSettings())
        .map(value => zio.aws.lakeformation.model.DataLakeSettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.GetDataLakeSettingsResponse
  ): zio.aws.lakeformation.model.GetDataLakeSettingsResponse.ReadOnly =
    new Wrapper(impl)
}
