package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.lakeformation.model.primitives.{NameString, CatalogIdString}
import scala.jdk.CollectionConverters._
final case class DatabaseResource(
    catalogId: Optional[CatalogIdString] = Optional.Absent,
    name: NameString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.DatabaseResource = {
    import DatabaseResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.DatabaseResource
      .builder()
      .optionallyWith(
        catalogId.map(value => CatalogIdString.unwrap(value): java.lang.String)
      )(_.catalogId)
      .name(NameString.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.DatabaseResource.ReadOnly =
    zio.aws.lakeformation.model.DatabaseResource.wrap(buildAwsValue())
}
object DatabaseResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.DatabaseResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.DatabaseResource =
      zio.aws.lakeformation.model
        .DatabaseResource(catalogId.map(value => value), name)
    def catalogId: Optional[CatalogIdString]
    def name: NameString
    def getCatalogId: ZIO[Any, AwsError, CatalogIdString] =
      AwsError.unwrapOptionField("catalogId", catalogId)
    def getName: ZIO[Any, Nothing, NameString] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.DatabaseResource
  ) extends zio.aws.lakeformation.model.DatabaseResource.ReadOnly {
    override val catalogId: Optional[CatalogIdString] = zio.aws.core.internal
      .optionalFromNullable(impl.catalogId())
      .map(value =>
        zio.aws.lakeformation.model.primitives.CatalogIdString(value)
      )
    override val name: NameString =
      zio.aws.lakeformation.model.primitives.NameString(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.DatabaseResource
  ): zio.aws.lakeformation.model.DatabaseResource.ReadOnly = new Wrapper(impl)
}
