package zio.aws.lakeformation
import zio.aws.lakeformation.model.primitives.{
  StorageOptimizerConfigKey,
  LFTagValue,
  PartitionValueString,
  StorageOptimizerConfigValue,
  NameString,
  RAMResourceShareArn,
  ValueString,
  CatalogIdString,
  StringValue
}
import zio.aws.lakeformation.model.primitives.StorageOptimizerConfigValue.Type
import java.time.Instant
import zio.Chunk
import zio.prelude.Subtype
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AccessKeyIdString extends Subtype[String]
    type AccessKeyIdString =
      zio.aws.lakeformation.model.primitives.AccessKeyIdString.Type
    object AuditContextString extends Subtype[String]
    type AuditContextString =
      zio.aws.lakeformation.model.primitives.AuditContextString.Type
    type BooleanNullable = Boolean
    object CatalogIdString extends Subtype[String]
    type CatalogIdString =
      zio.aws.lakeformation.model.primitives.CatalogIdString.Type
    object CredentialTimeoutDurationSecondInteger extends Subtype[Int]
    type CredentialTimeoutDurationSecondInteger =
      zio.aws.lakeformation.model.primitives.CredentialTimeoutDurationSecondInteger.Type
    object DataLakePrincipalString extends Subtype[String]
    type DataLakePrincipalString =
      zio.aws.lakeformation.model.primitives.DataLakePrincipalString.Type
    object DateTime extends Subtype[Instant]
    type DateTime = zio.aws.lakeformation.model.primitives.DateTime.Type
    object DescriptionString extends Subtype[String]
    type DescriptionString =
      zio.aws.lakeformation.model.primitives.DescriptionString.Type
    object ETagString extends Subtype[String]
    type ETagString = zio.aws.lakeformation.model.primitives.ETagString.Type
    object ErrorMessageString extends Subtype[String]
    type ErrorMessageString =
      zio.aws.lakeformation.model.primitives.ErrorMessageString.Type
    object ExpirationTimestamp extends Subtype[Instant]
    type ExpirationTimestamp =
      zio.aws.lakeformation.model.primitives.ExpirationTimestamp.Type
    object GetQueryStateRequestQueryIdString extends Subtype[String]
    type GetQueryStateRequestQueryIdString =
      zio.aws.lakeformation.model.primitives.GetQueryStateRequestQueryIdString.Type
    object GetQueryStatisticsRequestQueryIdString extends Subtype[String]
    type GetQueryStatisticsRequestQueryIdString =
      zio.aws.lakeformation.model.primitives.GetQueryStatisticsRequestQueryIdString.Type
    object GetWorkUnitResultsRequestQueryIdString extends Subtype[String]
    type GetWorkUnitResultsRequestQueryIdString =
      zio.aws.lakeformation.model.primitives.GetWorkUnitResultsRequestQueryIdString.Type
    object GetWorkUnitResultsRequestWorkUnitIdLong extends Subtype[Long]
    type GetWorkUnitResultsRequestWorkUnitIdLong =
      zio.aws.lakeformation.model.primitives.GetWorkUnitResultsRequestWorkUnitIdLong.Type
    object GetWorkUnitsRequestQueryIdString extends Subtype[String]
    type GetWorkUnitsRequestQueryIdString =
      zio.aws.lakeformation.model.primitives.GetWorkUnitsRequestQueryIdString.Type
    object IAMRoleArn extends Subtype[String]
    type IAMRoleArn = zio.aws.lakeformation.model.primitives.IAMRoleArn.Type
    object IAMSAMLProviderArn extends Subtype[String]
    type IAMSAMLProviderArn =
      zio.aws.lakeformation.model.primitives.IAMSAMLProviderArn.Type
    object Identifier extends Subtype[String]
    type Identifier = zio.aws.lakeformation.model.primitives.Identifier.Type
    type Integer = Int
    object LFTagKey extends Subtype[String]
    type LFTagKey = zio.aws.lakeformation.model.primitives.LFTagKey.Type
    object LFTagValue extends Subtype[String]
    type LFTagValue = zio.aws.lakeformation.model.primitives.LFTagValue.Type
    object LastModifiedTimestamp extends Subtype[Instant]
    type LastModifiedTimestamp =
      zio.aws.lakeformation.model.primitives.LastModifiedTimestamp.Type
    object MessageString extends Subtype[String]
    type MessageString =
      zio.aws.lakeformation.model.primitives.MessageString.Type
    object NameString extends Subtype[String]
    type NameString = zio.aws.lakeformation.model.primitives.NameString.Type
    type NullableBoolean = Boolean
    object NumberOfBytes extends Subtype[Long]
    type NumberOfBytes =
      zio.aws.lakeformation.model.primitives.NumberOfBytes.Type
    object NumberOfItems extends Subtype[Long]
    type NumberOfItems =
      zio.aws.lakeformation.model.primitives.NumberOfItems.Type
    object NumberOfMilliseconds extends Subtype[Long]
    type NumberOfMilliseconds =
      zio.aws.lakeformation.model.primitives.NumberOfMilliseconds.Type
    object ObjectSize extends Subtype[Long]
    type ObjectSize = zio.aws.lakeformation.model.primitives.ObjectSize.Type
    object PageSize extends Subtype[Int]
    type PageSize = zio.aws.lakeformation.model.primitives.PageSize.Type
    object PartitionValueString extends Subtype[String]
    type PartitionValueString =
      zio.aws.lakeformation.model.primitives.PartitionValueString.Type
    object PredicateString extends Subtype[String]
    type PredicateString =
      zio.aws.lakeformation.model.primitives.PredicateString.Type
    object QueryIdString extends Subtype[String]
    type QueryIdString =
      zio.aws.lakeformation.model.primitives.QueryIdString.Type
    object QueryPlanningContextDatabaseNameString extends Subtype[String]
    type QueryPlanningContextDatabaseNameString =
      zio.aws.lakeformation.model.primitives.QueryPlanningContextDatabaseNameString.Type
    object RAMResourceShareArn extends Subtype[String]
    type RAMResourceShareArn =
      zio.aws.lakeformation.model.primitives.RAMResourceShareArn.Type
    object ResourceArnString extends Subtype[String]
    type ResourceArnString =
      zio.aws.lakeformation.model.primitives.ResourceArnString.Type
    object Result extends Subtype[String]
    type Result = zio.aws.lakeformation.model.primitives.Result.Type
    object ResultStream extends Subtype[Chunk[Byte]]
    type ResultStream = zio.aws.lakeformation.model.primitives.ResultStream.Type
    object SAMLAssertionString extends Subtype[String]
    type SAMLAssertionString =
      zio.aws.lakeformation.model.primitives.SAMLAssertionString.Type
    object SecretAccessKeyString extends Subtype[String]
    type SecretAccessKeyString =
      zio.aws.lakeformation.model.primitives.SecretAccessKeyString.Type
    object SessionTokenString extends Subtype[String]
    type SessionTokenString =
      zio.aws.lakeformation.model.primitives.SessionTokenString.Type
    object StorageOptimizerConfigKey extends Subtype[String]
    type StorageOptimizerConfigKey =
      zio.aws.lakeformation.model.primitives.StorageOptimizerConfigKey.Type
    object StorageOptimizerConfigValue extends Subtype[String]
    type StorageOptimizerConfigValue =
      zio.aws.lakeformation.model.primitives.StorageOptimizerConfigValue.Type
    object StringValue extends Subtype[String]
    type StringValue = zio.aws.lakeformation.model.primitives.StringValue.Type
    object SyntheticGetWorkUnitResultsRequestWorkUnitTokenString
        extends Subtype[String]
    type SyntheticGetWorkUnitResultsRequestWorkUnitTokenString =
      zio.aws.lakeformation.model.primitives.SyntheticGetWorkUnitResultsRequestWorkUnitTokenString.Type
    object SyntheticStartQueryPlanningRequestQueryString extends Subtype[String]
    type SyntheticStartQueryPlanningRequestQueryString =
      zio.aws.lakeformation.model.primitives.SyntheticStartQueryPlanningRequestQueryString.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.lakeformation.model.primitives.Timestamp.Type
    object Token extends Subtype[String]
    type Token = zio.aws.lakeformation.model.primitives.Token.Type
    object TokenString extends Subtype[String]
    type TokenString = zio.aws.lakeformation.model.primitives.TokenString.Type
    object TransactionIdString extends Subtype[String]
    type TransactionIdString =
      zio.aws.lakeformation.model.primitives.TransactionIdString.Type
    object TrueFalseString extends Subtype[String]
    type TrueFalseString =
      zio.aws.lakeformation.model.primitives.TrueFalseString.Type
    object URI extends Subtype[String]
    type URI = zio.aws.lakeformation.model.primitives.URI.Type
    object ValueString extends Subtype[String]
    type ValueString = zio.aws.lakeformation.model.primitives.ValueString.Type
    object WorkUnitIdLong extends Subtype[Long]
    type WorkUnitIdLong =
      zio.aws.lakeformation.model.primitives.WorkUnitIdLong.Type
    object WorkUnitTokenString extends Subtype[String]
    type WorkUnitTokenString =
      zio.aws.lakeformation.model.primitives.WorkUnitTokenString.Type
  }
  type AuthorizedSessionTagValueList = List[NameString]
  type BatchPermissionsFailureList =
    List[zio.aws.lakeformation.model.BatchPermissionsFailureEntry]
  type BatchPermissionsRequestEntryList =
    List[zio.aws.lakeformation.model.BatchPermissionsRequestEntry]
  type ColumnLFTagsList = List[zio.aws.lakeformation.model.ColumnLFTag]
  type ColumnNames = List[NameString]
  type DataCellsFilterList = List[zio.aws.lakeformation.model.DataCellsFilter]
  type DataLakePrincipalList =
    List[zio.aws.lakeformation.model.DataLakePrincipal]
  type DatabaseLFTagsList = List[zio.aws.lakeformation.model.TaggedDatabase]
  type Expression = List[zio.aws.lakeformation.model.LFTag]
  type FilterConditionList = List[zio.aws.lakeformation.model.FilterCondition]
  type LFTagErrors = List[zio.aws.lakeformation.model.LFTagError]
  type LFTagsList = List[zio.aws.lakeformation.model.LFTagPair]
  type PartitionValuesList = List[PartitionValueString]
  type PartitionedTableObjectsList =
    List[zio.aws.lakeformation.model.PartitionObjects]
  type PermissionList = List[zio.aws.lakeformation.model.Permission]
  type PermissionTypeList = List[zio.aws.lakeformation.model.PermissionType]
  type PrincipalPermissionsList =
    List[zio.aws.lakeformation.model.PrincipalPermissions]
  type PrincipalResourcePermissionsList =
    List[zio.aws.lakeformation.model.PrincipalResourcePermissions]
  type QueryParameterMap = Map[String, String]
  type ResourceInfoList = List[zio.aws.lakeformation.model.ResourceInfo]
  type ResourceShareList = List[RAMResourceShareArn]
  type StorageOptimizerConfig =
    Map[StorageOptimizerConfigKey, StorageOptimizerConfigValue]
  type StorageOptimizerConfigMap = Map[
    zio.aws.lakeformation.model.OptimizerType,
    Map[StorageOptimizerConfigKey, StorageOptimizerConfigValue]
  ]
  type StorageOptimizerList = List[zio.aws.lakeformation.model.StorageOptimizer]
  type StringValueList = List[StringValue]
  type TableLFTagsList = List[zio.aws.lakeformation.model.TaggedTable]
  type TableObjectList = List[zio.aws.lakeformation.model.TableObject]
  type TagValueList = List[LFTagValue]
  type TransactionDescriptionList =
    List[zio.aws.lakeformation.model.TransactionDescription]
  type TrustedResourceOwners = List[CatalogIdString]
  type ValueStringList = List[ValueString]
  type VirtualObjectList = List[zio.aws.lakeformation.model.VirtualObject]
  type WorkUnitRangeList = List[zio.aws.lakeformation.model.WorkUnitRange]
  type WriteOperationList = List[zio.aws.lakeformation.model.WriteOperation]
}
