package zio.aws.lakeformation.model
import zio.aws.lakeformation.model.primitives.{
  CredentialTimeoutDurationSecondInteger,
  IAMSAMLProviderArn,
  IAMRoleArn,
  SAMLAssertionString
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class AssumeDecoratedRoleWithSamlRequest(
    samlAssertion: SAMLAssertionString,
    roleArn: IAMRoleArn,
    principalArn: IAMSAMLProviderArn,
    durationSeconds: Optional[CredentialTimeoutDurationSecondInteger] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.AssumeDecoratedRoleWithSamlRequest = {
    import AssumeDecoratedRoleWithSamlRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.AssumeDecoratedRoleWithSamlRequest
      .builder()
      .samlAssertion(
        SAMLAssertionString.unwrap(samlAssertion): java.lang.String
      )
      .roleArn(IAMRoleArn.unwrap(roleArn): java.lang.String)
      .principalArn(IAMSAMLProviderArn.unwrap(principalArn): java.lang.String)
      .optionallyWith(
        durationSeconds.map(value =>
          CredentialTimeoutDurationSecondInteger.unwrap(value): Integer
        )
      )(_.durationSeconds)
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.AssumeDecoratedRoleWithSamlRequest.ReadOnly =
    zio.aws.lakeformation.model.AssumeDecoratedRoleWithSamlRequest
      .wrap(buildAwsValue())
}
object AssumeDecoratedRoleWithSamlRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.AssumeDecoratedRoleWithSamlRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lakeformation.model.AssumeDecoratedRoleWithSamlRequest =
      zio.aws.lakeformation.model.AssumeDecoratedRoleWithSamlRequest(
        samlAssertion,
        roleArn,
        principalArn,
        durationSeconds.map(value => value)
      )
    def samlAssertion: SAMLAssertionString
    def roleArn: IAMRoleArn
    def principalArn: IAMSAMLProviderArn
    def durationSeconds: Optional[CredentialTimeoutDurationSecondInteger]
    def getSamlAssertion: ZIO[Any, Nothing, SAMLAssertionString] =
      ZIO.succeed(samlAssertion)
    def getRoleArn: ZIO[Any, Nothing, IAMRoleArn] = ZIO.succeed(roleArn)
    def getPrincipalArn: ZIO[Any, Nothing, IAMSAMLProviderArn] =
      ZIO.succeed(principalArn)
    def getDurationSeconds
        : ZIO[Any, AwsError, CredentialTimeoutDurationSecondInteger] =
      AwsError.unwrapOptionField("durationSeconds", durationSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.AssumeDecoratedRoleWithSamlRequest
  ) extends zio.aws.lakeformation.model.AssumeDecoratedRoleWithSamlRequest.ReadOnly {
    override val samlAssertion: SAMLAssertionString =
      zio.aws.lakeformation.model.primitives
        .SAMLAssertionString(impl.samlAssertion())
    override val roleArn: IAMRoleArn =
      zio.aws.lakeformation.model.primitives.IAMRoleArn(impl.roleArn())
    override val principalArn: IAMSAMLProviderArn =
      zio.aws.lakeformation.model.primitives
        .IAMSAMLProviderArn(impl.principalArn())
    override val durationSeconds
        : Optional[CredentialTimeoutDurationSecondInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.durationSeconds())
        .map(value =>
          zio.aws.lakeformation.model.primitives
            .CredentialTimeoutDurationSecondInteger(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.AssumeDecoratedRoleWithSamlRequest
  ): zio.aws.lakeformation.model.AssumeDecoratedRoleWithSamlRequest.ReadOnly =
    new Wrapper(impl)
}
