package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AddLfTagsToResourceResponse(
    failures: Optional[Iterable[zio.aws.lakeformation.model.LFTagError]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.AddLfTagsToResourceResponse = {
    import AddLfTagsToResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.AddLfTagsToResourceResponse
      .builder()
      .optionallyWith(
        failures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failures)
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.AddLfTagsToResourceResponse.ReadOnly =
    zio.aws.lakeformation.model.AddLfTagsToResourceResponse
      .wrap(buildAwsValue())
}
object AddLfTagsToResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.AddLfTagsToResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.AddLfTagsToResourceResponse =
      zio.aws.lakeformation.model.AddLfTagsToResourceResponse(
        failures.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def failures
        : Optional[List[zio.aws.lakeformation.model.LFTagError.ReadOnly]]
    def getFailures: ZIO[Any, AwsError, List[
      zio.aws.lakeformation.model.LFTagError.ReadOnly
    ]] = AwsError.unwrapOptionField("failures", failures)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.AddLfTagsToResourceResponse
  ) extends zio.aws.lakeformation.model.AddLfTagsToResourceResponse.ReadOnly {
    override val failures
        : Optional[List[zio.aws.lakeformation.model.LFTagError.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failures())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lakeformation.model.LFTagError.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.AddLfTagsToResourceResponse
  ): zio.aws.lakeformation.model.AddLfTagsToResourceResponse.ReadOnly =
    new Wrapper(impl)
}
