package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.lakeformation.model.primitives.SyntheticStartQueryPlanningRequestQueryString
import scala.jdk.CollectionConverters._
final case class StartQueryPlanningRequest(
    queryPlanningContext: zio.aws.lakeformation.model.QueryPlanningContext,
    queryString: SyntheticStartQueryPlanningRequestQueryString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.StartQueryPlanningRequest = {
    import StartQueryPlanningRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.StartQueryPlanningRequest
      .builder()
      .queryPlanningContext(queryPlanningContext.buildAwsValue())
      .queryString(
        SyntheticStartQueryPlanningRequestQueryString.unwrap(
          queryString
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.StartQueryPlanningRequest.ReadOnly =
    zio.aws.lakeformation.model.StartQueryPlanningRequest.wrap(buildAwsValue())
}
object StartQueryPlanningRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.StartQueryPlanningRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.StartQueryPlanningRequest =
      zio.aws.lakeformation.model
        .StartQueryPlanningRequest(queryPlanningContext.asEditable, queryString)
    def queryPlanningContext
        : zio.aws.lakeformation.model.QueryPlanningContext.ReadOnly
    def queryString: SyntheticStartQueryPlanningRequestQueryString
    def getQueryPlanningContext: ZIO[
      Any,
      Nothing,
      zio.aws.lakeformation.model.QueryPlanningContext.ReadOnly
    ] = ZIO.succeed(queryPlanningContext)
    def getQueryString
        : ZIO[Any, Nothing, SyntheticStartQueryPlanningRequestQueryString] =
      ZIO.succeed(queryString)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.StartQueryPlanningRequest
  ) extends zio.aws.lakeformation.model.StartQueryPlanningRequest.ReadOnly {
    override val queryPlanningContext
        : zio.aws.lakeformation.model.QueryPlanningContext.ReadOnly =
      zio.aws.lakeformation.model.QueryPlanningContext
        .wrap(impl.queryPlanningContext())
    override val queryString: SyntheticStartQueryPlanningRequestQueryString =
      zio.aws.lakeformation.model.primitives
        .SyntheticStartQueryPlanningRequestQueryString(impl.queryString())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.StartQueryPlanningRequest
  ): zio.aws.lakeformation.model.StartQueryPlanningRequest.ReadOnly =
    new Wrapper(impl)
}
