package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Resource(
    catalog: Optional[zio.aws.lakeformation.model.CatalogResource] =
      Optional.Absent,
    database: Optional[zio.aws.lakeformation.model.DatabaseResource] =
      Optional.Absent,
    table: Optional[zio.aws.lakeformation.model.TableResource] =
      Optional.Absent,
    tableWithColumns: Optional[
      zio.aws.lakeformation.model.TableWithColumnsResource
    ] = Optional.Absent,
    dataLocation: Optional[zio.aws.lakeformation.model.DataLocationResource] =
      Optional.Absent,
    dataCellsFilter: Optional[
      zio.aws.lakeformation.model.DataCellsFilterResource
    ] = Optional.Absent,
    lfTag: Optional[zio.aws.lakeformation.model.LFTagKeyResource] =
      Optional.Absent,
    lfTagPolicy: Optional[zio.aws.lakeformation.model.LFTagPolicyResource] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.Resource = {
    import Resource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.Resource
      .builder()
      .optionallyWith(catalog.map(value => value.buildAwsValue()))(_.catalog)
      .optionallyWith(database.map(value => value.buildAwsValue()))(_.database)
      .optionallyWith(table.map(value => value.buildAwsValue()))(_.table)
      .optionallyWith(tableWithColumns.map(value => value.buildAwsValue()))(
        _.tableWithColumns
      )
      .optionallyWith(dataLocation.map(value => value.buildAwsValue()))(
        _.dataLocation
      )
      .optionallyWith(dataCellsFilter.map(value => value.buildAwsValue()))(
        _.dataCellsFilter
      )
      .optionallyWith(lfTag.map(value => value.buildAwsValue()))(_.lfTag)
      .optionallyWith(lfTagPolicy.map(value => value.buildAwsValue()))(
        _.lfTagPolicy
      )
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.Resource.ReadOnly =
    zio.aws.lakeformation.model.Resource.wrap(buildAwsValue())
}
object Resource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.Resource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.Resource =
      zio.aws.lakeformation.model.Resource(
        catalog.map(value => value.asEditable),
        database.map(value => value.asEditable),
        table.map(value => value.asEditable),
        tableWithColumns.map(value => value.asEditable),
        dataLocation.map(value => value.asEditable),
        dataCellsFilter.map(value => value.asEditable),
        lfTag.map(value => value.asEditable),
        lfTagPolicy.map(value => value.asEditable)
      )
    def catalog: Optional[zio.aws.lakeformation.model.CatalogResource.ReadOnly]
    def database
        : Optional[zio.aws.lakeformation.model.DatabaseResource.ReadOnly]
    def table: Optional[zio.aws.lakeformation.model.TableResource.ReadOnly]
    def tableWithColumns: Optional[
      zio.aws.lakeformation.model.TableWithColumnsResource.ReadOnly
    ]
    def dataLocation
        : Optional[zio.aws.lakeformation.model.DataLocationResource.ReadOnly]
    def dataCellsFilter
        : Optional[zio.aws.lakeformation.model.DataCellsFilterResource.ReadOnly]
    def lfTag: Optional[zio.aws.lakeformation.model.LFTagKeyResource.ReadOnly]
    def lfTagPolicy
        : Optional[zio.aws.lakeformation.model.LFTagPolicyResource.ReadOnly]
    def getCatalog: ZIO[
      Any,
      AwsError,
      zio.aws.lakeformation.model.CatalogResource.ReadOnly
    ] = AwsError.unwrapOptionField("catalog", catalog)
    def getDatabase: ZIO[
      Any,
      AwsError,
      zio.aws.lakeformation.model.DatabaseResource.ReadOnly
    ] = AwsError.unwrapOptionField("database", database)
    def getTable: ZIO[
      Any,
      AwsError,
      zio.aws.lakeformation.model.TableResource.ReadOnly
    ] = AwsError.unwrapOptionField("table", table)
    def getTableWithColumns: ZIO[
      Any,
      AwsError,
      zio.aws.lakeformation.model.TableWithColumnsResource.ReadOnly
    ] = AwsError.unwrapOptionField("tableWithColumns", tableWithColumns)
    def getDataLocation: ZIO[
      Any,
      AwsError,
      zio.aws.lakeformation.model.DataLocationResource.ReadOnly
    ] = AwsError.unwrapOptionField("dataLocation", dataLocation)
    def getDataCellsFilter: ZIO[
      Any,
      AwsError,
      zio.aws.lakeformation.model.DataCellsFilterResource.ReadOnly
    ] = AwsError.unwrapOptionField("dataCellsFilter", dataCellsFilter)
    def getLfTag: ZIO[
      Any,
      AwsError,
      zio.aws.lakeformation.model.LFTagKeyResource.ReadOnly
    ] = AwsError.unwrapOptionField("lfTag", lfTag)
    def getLfTagPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.lakeformation.model.LFTagPolicyResource.ReadOnly
    ] = AwsError.unwrapOptionField("lfTagPolicy", lfTagPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.Resource
  ) extends zio.aws.lakeformation.model.Resource.ReadOnly {
    override val catalog
        : Optional[zio.aws.lakeformation.model.CatalogResource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.catalog())
        .map(value => zio.aws.lakeformation.model.CatalogResource.wrap(value))
    override val database
        : Optional[zio.aws.lakeformation.model.DatabaseResource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.database())
        .map(value => zio.aws.lakeformation.model.DatabaseResource.wrap(value))
    override val table
        : Optional[zio.aws.lakeformation.model.TableResource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.table())
        .map(value => zio.aws.lakeformation.model.TableResource.wrap(value))
    override val tableWithColumns: Optional[
      zio.aws.lakeformation.model.TableWithColumnsResource.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.tableWithColumns())
      .map(value =>
        zio.aws.lakeformation.model.TableWithColumnsResource.wrap(value)
      )
    override val dataLocation
        : Optional[zio.aws.lakeformation.model.DataLocationResource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataLocation())
        .map(value =>
          zio.aws.lakeformation.model.DataLocationResource.wrap(value)
        )
    override val dataCellsFilter: Optional[
      zio.aws.lakeformation.model.DataCellsFilterResource.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dataCellsFilter())
      .map(value =>
        zio.aws.lakeformation.model.DataCellsFilterResource.wrap(value)
      )
    override val lfTag
        : Optional[zio.aws.lakeformation.model.LFTagKeyResource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lfTag())
        .map(value => zio.aws.lakeformation.model.LFTagKeyResource.wrap(value))
    override val lfTagPolicy
        : Optional[zio.aws.lakeformation.model.LFTagPolicyResource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lfTagPolicy())
        .map(value =>
          zio.aws.lakeformation.model.LFTagPolicyResource.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.Resource
  ): zio.aws.lakeformation.model.Resource.ReadOnly = new Wrapper(impl)
}
