package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.lakeformation.model.primitives.{
  NumberOfItems,
  NumberOfMilliseconds,
  NumberOfBytes
}
import scala.jdk.CollectionConverters._
final case class PlanningStatistics(
    estimatedDataToScanBytes: Optional[NumberOfBytes] = Optional.Absent,
    planningTimeMillis: Optional[NumberOfMilliseconds] = Optional.Absent,
    queueTimeMillis: Optional[NumberOfMilliseconds] = Optional.Absent,
    workUnitsGeneratedCount: Optional[NumberOfItems] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.PlanningStatistics = {
    import PlanningStatistics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.PlanningStatistics
      .builder()
      .optionallyWith(
        estimatedDataToScanBytes.map(value =>
          NumberOfBytes.unwrap(value): java.lang.Long
        )
      )(_.estimatedDataToScanBytes)
      .optionallyWith(
        planningTimeMillis.map(value =>
          NumberOfMilliseconds.unwrap(value): java.lang.Long
        )
      )(_.planningTimeMillis)
      .optionallyWith(
        queueTimeMillis.map(value =>
          NumberOfMilliseconds.unwrap(value): java.lang.Long
        )
      )(_.queueTimeMillis)
      .optionallyWith(
        workUnitsGeneratedCount.map(value =>
          NumberOfItems.unwrap(value): java.lang.Long
        )
      )(_.workUnitsGeneratedCount)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.PlanningStatistics.ReadOnly =
    zio.aws.lakeformation.model.PlanningStatistics.wrap(buildAwsValue())
}
object PlanningStatistics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.PlanningStatistics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.PlanningStatistics =
      zio.aws.lakeformation.model.PlanningStatistics(
        estimatedDataToScanBytes.map(value => value),
        planningTimeMillis.map(value => value),
        queueTimeMillis.map(value => value),
        workUnitsGeneratedCount.map(value => value)
      )
    def estimatedDataToScanBytes: Optional[NumberOfBytes]
    def planningTimeMillis: Optional[NumberOfMilliseconds]
    def queueTimeMillis: Optional[NumberOfMilliseconds]
    def workUnitsGeneratedCount: Optional[NumberOfItems]
    def getEstimatedDataToScanBytes: ZIO[Any, AwsError, NumberOfBytes] =
      AwsError.unwrapOptionField(
        "estimatedDataToScanBytes",
        estimatedDataToScanBytes
      )
    def getPlanningTimeMillis: ZIO[Any, AwsError, NumberOfMilliseconds] =
      AwsError.unwrapOptionField("planningTimeMillis", planningTimeMillis)
    def getQueueTimeMillis: ZIO[Any, AwsError, NumberOfMilliseconds] =
      AwsError.unwrapOptionField("queueTimeMillis", queueTimeMillis)
    def getWorkUnitsGeneratedCount: ZIO[Any, AwsError, NumberOfItems] = AwsError
      .unwrapOptionField("workUnitsGeneratedCount", workUnitsGeneratedCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.PlanningStatistics
  ) extends zio.aws.lakeformation.model.PlanningStatistics.ReadOnly {
    override val estimatedDataToScanBytes: Optional[NumberOfBytes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.estimatedDataToScanBytes())
        .map(value =>
          zio.aws.lakeformation.model.primitives.NumberOfBytes(value)
        )
    override val planningTimeMillis: Optional[NumberOfMilliseconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.planningTimeMillis())
        .map(value =>
          zio.aws.lakeformation.model.primitives.NumberOfMilliseconds(value)
        )
    override val queueTimeMillis: Optional[NumberOfMilliseconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queueTimeMillis())
        .map(value =>
          zio.aws.lakeformation.model.primitives.NumberOfMilliseconds(value)
        )
    override val workUnitsGeneratedCount: Optional[NumberOfItems] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workUnitsGeneratedCount())
        .map(value =>
          zio.aws.lakeformation.model.primitives.NumberOfItems(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.PlanningStatistics
  ): zio.aws.lakeformation.model.PlanningStatistics.ReadOnly = new Wrapper(impl)
}
