package zio.aws.lakeformation.model
import zio.aws.lakeformation.model.primitives.{Token, PageSize}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListResourcesRequest(
    filterConditionList: Optional[
      Iterable[zio.aws.lakeformation.model.FilterCondition]
    ] = Optional.Absent,
    maxResults: Optional[PageSize] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.ListResourcesRequest = {
    import ListResourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.ListResourcesRequest
      .builder()
      .optionallyWith(
        filterConditionList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filterConditionList)
      .optionallyWith(maxResults.map(value => PageSize.unwrap(value): Integer))(
        _.maxResults
      )
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.ListResourcesRequest.ReadOnly =
    zio.aws.lakeformation.model.ListResourcesRequest.wrap(buildAwsValue())
}
object ListResourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.ListResourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.ListResourcesRequest =
      zio.aws.lakeformation.model.ListResourcesRequest(
        filterConditionList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def filterConditionList
        : Optional[List[zio.aws.lakeformation.model.FilterCondition.ReadOnly]]
    def maxResults: Optional[PageSize]
    def nextToken: Optional[Token]
    def getFilterConditionList: ZIO[Any, AwsError, List[
      zio.aws.lakeformation.model.FilterCondition.ReadOnly
    ]] = AwsError.unwrapOptionField("filterConditionList", filterConditionList)
    def getMaxResults: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.ListResourcesRequest
  ) extends zio.aws.lakeformation.model.ListResourcesRequest.ReadOnly {
    override val filterConditionList
        : Optional[List[zio.aws.lakeformation.model.FilterCondition.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filterConditionList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lakeformation.model.FilterCondition.wrap(item)
          }.toList
        )
    override val maxResults: Optional[PageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.lakeformation.model.primitives.PageSize(value))
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lakeformation.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.ListResourcesRequest
  ): zio.aws.lakeformation.model.ListResourcesRequest.ReadOnly = new Wrapper(
    impl
  )
}
