package zio.aws.lakeformation.model
import zio.aws.lakeformation.model.primitives.{Token, PageSize, CatalogIdString}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListLfTagsRequest(
    catalogId: Optional[CatalogIdString] = Optional.Absent,
    resourceShareType: Optional[zio.aws.lakeformation.model.ResourceShareType] =
      Optional.Absent,
    maxResults: Optional[PageSize] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.ListLfTagsRequest = {
    import ListLfTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.ListLfTagsRequest
      .builder()
      .optionallyWith(
        catalogId.map(value => CatalogIdString.unwrap(value): java.lang.String)
      )(_.catalogId)
      .optionallyWith(resourceShareType.map(value => value.unwrap))(
        _.resourceShareType
      )
      .optionallyWith(maxResults.map(value => PageSize.unwrap(value): Integer))(
        _.maxResults
      )
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.ListLfTagsRequest.ReadOnly =
    zio.aws.lakeformation.model.ListLfTagsRequest.wrap(buildAwsValue())
}
object ListLfTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.ListLfTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.ListLfTagsRequest =
      zio.aws.lakeformation.model.ListLfTagsRequest(
        catalogId.map(value => value),
        resourceShareType.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def catalogId: Optional[CatalogIdString]
    def resourceShareType
        : Optional[zio.aws.lakeformation.model.ResourceShareType]
    def maxResults: Optional[PageSize]
    def nextToken: Optional[Token]
    def getCatalogId: ZIO[Any, AwsError, CatalogIdString] =
      AwsError.unwrapOptionField("catalogId", catalogId)
    def getResourceShareType
        : ZIO[Any, AwsError, zio.aws.lakeformation.model.ResourceShareType] =
      AwsError.unwrapOptionField("resourceShareType", resourceShareType)
    def getMaxResults: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.ListLfTagsRequest
  ) extends zio.aws.lakeformation.model.ListLfTagsRequest.ReadOnly {
    override val catalogId: Optional[CatalogIdString] = zio.aws.core.internal
      .optionalFromNullable(impl.catalogId())
      .map(value =>
        zio.aws.lakeformation.model.primitives.CatalogIdString(value)
      )
    override val resourceShareType
        : Optional[zio.aws.lakeformation.model.ResourceShareType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceShareType())
        .map(value => zio.aws.lakeformation.model.ResourceShareType.wrap(value))
    override val maxResults: Optional[PageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.lakeformation.model.primitives.PageSize(value))
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lakeformation.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.ListLfTagsRequest
  ): zio.aws.lakeformation.model.ListLfTagsRequest.ReadOnly = new Wrapper(impl)
}
