package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.lakeformation.model.primitives.{NameString, CatalogIdString}
import scala.jdk.CollectionConverters._
final case class DataCellsFilterResource(
    tableCatalogId: Optional[CatalogIdString] = Optional.Absent,
    databaseName: Optional[NameString] = Optional.Absent,
    tableName: Optional[NameString] = Optional.Absent,
    name: Optional[NameString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.DataCellsFilterResource = {
    import DataCellsFilterResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.DataCellsFilterResource
      .builder()
      .optionallyWith(
        tableCatalogId.map(value =>
          CatalogIdString.unwrap(value): java.lang.String
        )
      )(_.tableCatalogId)
      .optionallyWith(
        databaseName.map(value => NameString.unwrap(value): java.lang.String)
      )(_.databaseName)
      .optionallyWith(
        tableName.map(value => NameString.unwrap(value): java.lang.String)
      )(_.tableName)
      .optionallyWith(
        name.map(value => NameString.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.DataCellsFilterResource.ReadOnly =
    zio.aws.lakeformation.model.DataCellsFilterResource.wrap(buildAwsValue())
}
object DataCellsFilterResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.DataCellsFilterResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.DataCellsFilterResource =
      zio.aws.lakeformation.model.DataCellsFilterResource(
        tableCatalogId.map(value => value),
        databaseName.map(value => value),
        tableName.map(value => value),
        name.map(value => value)
      )
    def tableCatalogId: Optional[CatalogIdString]
    def databaseName: Optional[NameString]
    def tableName: Optional[NameString]
    def name: Optional[NameString]
    def getTableCatalogId: ZIO[Any, AwsError, CatalogIdString] =
      AwsError.unwrapOptionField("tableCatalogId", tableCatalogId)
    def getDatabaseName: ZIO[Any, AwsError, NameString] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getTableName: ZIO[Any, AwsError, NameString] =
      AwsError.unwrapOptionField("tableName", tableName)
    def getName: ZIO[Any, AwsError, NameString] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.DataCellsFilterResource
  ) extends zio.aws.lakeformation.model.DataCellsFilterResource.ReadOnly {
    override val tableCatalogId: Optional[CatalogIdString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tableCatalogId())
        .map(value =>
          zio.aws.lakeformation.model.primitives.CatalogIdString(value)
        )
    override val databaseName: Optional[NameString] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseName())
      .map(value => zio.aws.lakeformation.model.primitives.NameString(value))
    override val tableName: Optional[NameString] = zio.aws.core.internal
      .optionalFromNullable(impl.tableName())
      .map(value => zio.aws.lakeformation.model.primitives.NameString(value))
    override val name: Optional[NameString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.lakeformation.model.primitives.NameString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.DataCellsFilterResource
  ): zio.aws.lakeformation.model.DataCellsFilterResource.ReadOnly = new Wrapper(
    impl
  )
}
