package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.lakeformation.model.primitives.TransactionIdString
import scala.jdk.CollectionConverters._
final case class CommitTransactionRequest(transactionId: TransactionIdString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.CommitTransactionRequest = {
    import CommitTransactionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.CommitTransactionRequest
      .builder()
      .transactionId(
        TransactionIdString.unwrap(transactionId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.CommitTransactionRequest.ReadOnly =
    zio.aws.lakeformation.model.CommitTransactionRequest.wrap(buildAwsValue())
}
object CommitTransactionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.CommitTransactionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.CommitTransactionRequest =
      zio.aws.lakeformation.model.CommitTransactionRequest(transactionId)
    def transactionId: TransactionIdString
    def getTransactionId: ZIO[Any, Nothing, TransactionIdString] =
      ZIO.succeed(transactionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.CommitTransactionRequest
  ) extends zio.aws.lakeformation.model.CommitTransactionRequest.ReadOnly {
    override val transactionId: TransactionIdString =
      zio.aws.lakeformation.model.primitives
        .TransactionIdString(impl.transactionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.CommitTransactionRequest
  ): zio.aws.lakeformation.model.CommitTransactionRequest.ReadOnly =
    new Wrapper(impl)
}
