package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.lakeformation.model.primitives.{ResourceArnString, IAMRoleArn}
import scala.jdk.CollectionConverters._
final case class UpdateResourceRequest(
    roleArn: IAMRoleArn,
    resourceArn: ResourceArnString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.UpdateResourceRequest = {
    import UpdateResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.UpdateResourceRequest
      .builder()
      .roleArn(IAMRoleArn.unwrap(roleArn): java.lang.String)
      .resourceArn(ResourceArnString.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.UpdateResourceRequest.ReadOnly =
    zio.aws.lakeformation.model.UpdateResourceRequest.wrap(buildAwsValue())
}
object UpdateResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.UpdateResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.UpdateResourceRequest =
      zio.aws.lakeformation.model.UpdateResourceRequest(roleArn, resourceArn)
    def roleArn: IAMRoleArn
    def resourceArn: ResourceArnString
    def getRoleArn: ZIO[Any, Nothing, IAMRoleArn] = ZIO.succeed(roleArn)
    def getResourceArn: ZIO[Any, Nothing, ResourceArnString] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.UpdateResourceRequest
  ) extends zio.aws.lakeformation.model.UpdateResourceRequest.ReadOnly {
    override val roleArn: IAMRoleArn =
      zio.aws.lakeformation.model.primitives.IAMRoleArn(impl.roleArn())
    override val resourceArn: ResourceArnString =
      zio.aws.lakeformation.model.primitives
        .ResourceArnString(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.UpdateResourceRequest
  ): zio.aws.lakeformation.model.UpdateResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
