package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.lakeformation.model.primitives.{DescriptionString, NameString}
import scala.jdk.CollectionConverters._
final case class ErrorDetail(
    errorCode: Optional[NameString] = Optional.Absent,
    errorMessage: Optional[DescriptionString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.ErrorDetail = {
    import ErrorDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.ErrorDetail
      .builder()
      .optionallyWith(
        errorCode.map(value => NameString.unwrap(value): java.lang.String)
      )(_.errorCode)
      .optionallyWith(
        errorMessage.map(value =>
          DescriptionString.unwrap(value): java.lang.String
        )
      )(_.errorMessage)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.ErrorDetail.ReadOnly =
    zio.aws.lakeformation.model.ErrorDetail.wrap(buildAwsValue())
}
object ErrorDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.ErrorDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.ErrorDetail =
      zio.aws.lakeformation.model.ErrorDetail(
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def errorCode: Optional[NameString]
    def errorMessage: Optional[DescriptionString]
    def getErrorCode: ZIO[Any, AwsError, NameString] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, DescriptionString] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.ErrorDetail
  ) extends zio.aws.lakeformation.model.ErrorDetail.ReadOnly {
    override val errorCode: Optional[NameString] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCode())
      .map(value => zio.aws.lakeformation.model.primitives.NameString(value))
    override val errorMessage: Optional[DescriptionString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorMessage())
        .map(value =>
          zio.aws.lakeformation.model.primitives.DescriptionString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.ErrorDetail
  ): zio.aws.lakeformation.model.ErrorDetail.ReadOnly = new Wrapper(impl)
}
