package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.lakeformation.model.primitives.{NameString, CatalogIdString}
import scala.jdk.CollectionConverters._
final case class DeleteDataCellsFilterRequest(
    tableCatalogId: Optional[CatalogIdString] = Optional.Absent,
    databaseName: Optional[NameString] = Optional.Absent,
    tableName: Optional[NameString] = Optional.Absent,
    name: Optional[NameString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.DeleteDataCellsFilterRequest = {
    import DeleteDataCellsFilterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.DeleteDataCellsFilterRequest
      .builder()
      .optionallyWith(
        tableCatalogId.map(value =>
          CatalogIdString.unwrap(value): java.lang.String
        )
      )(_.tableCatalogId)
      .optionallyWith(
        databaseName.map(value => NameString.unwrap(value): java.lang.String)
      )(_.databaseName)
      .optionallyWith(
        tableName.map(value => NameString.unwrap(value): java.lang.String)
      )(_.tableName)
      .optionallyWith(
        name.map(value => NameString.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.DeleteDataCellsFilterRequest.ReadOnly =
    zio.aws.lakeformation.model.DeleteDataCellsFilterRequest
      .wrap(buildAwsValue())
}
object DeleteDataCellsFilterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.DeleteDataCellsFilterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.DeleteDataCellsFilterRequest =
      zio.aws.lakeformation.model.DeleteDataCellsFilterRequest(
        tableCatalogId.map(value => value),
        databaseName.map(value => value),
        tableName.map(value => value),
        name.map(value => value)
      )
    def tableCatalogId: Optional[CatalogIdString]
    def databaseName: Optional[NameString]
    def tableName: Optional[NameString]
    def name: Optional[NameString]
    def getTableCatalogId: ZIO[Any, AwsError, CatalogIdString] =
      AwsError.unwrapOptionField("tableCatalogId", tableCatalogId)
    def getDatabaseName: ZIO[Any, AwsError, NameString] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getTableName: ZIO[Any, AwsError, NameString] =
      AwsError.unwrapOptionField("tableName", tableName)
    def getName: ZIO[Any, AwsError, NameString] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.DeleteDataCellsFilterRequest
  ) extends zio.aws.lakeformation.model.DeleteDataCellsFilterRequest.ReadOnly {
    override val tableCatalogId: Optional[CatalogIdString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tableCatalogId())
        .map(value =>
          zio.aws.lakeformation.model.primitives.CatalogIdString(value)
        )
    override val databaseName: Optional[NameString] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseName())
      .map(value => zio.aws.lakeformation.model.primitives.NameString(value))
    override val tableName: Optional[NameString] = zio.aws.core.internal
      .optionalFromNullable(impl.tableName())
      .map(value => zio.aws.lakeformation.model.primitives.NameString(value))
    override val name: Optional[NameString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.lakeformation.model.primitives.NameString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.DeleteDataCellsFilterRequest
  ): zio.aws.lakeformation.model.DeleteDataCellsFilterRequest.ReadOnly =
    new Wrapper(impl)
}
