package zio.aws.lakeformation.model
import scala.jdk.CollectionConverters._
sealed trait ResourceType {
  def unwrap: software.amazon.awssdk.services.lakeformation.model.ResourceType
}
object ResourceType {
  def wrap(
      value: software.amazon.awssdk.services.lakeformation.model.ResourceType
  ): zio.aws.lakeformation.model.ResourceType = value match {
    case software.amazon.awssdk.services.lakeformation.model.ResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lakeformation.model.ResourceType.DATABASE =>
      val r = DATABASE
      r
    case software.amazon.awssdk.services.lakeformation.model.ResourceType.TABLE =>
      val r = TABLE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lakeformation.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.ResourceType =
      software.amazon.awssdk.services.lakeformation.model.ResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object DATABASE extends zio.aws.lakeformation.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.ResourceType =
      software.amazon.awssdk.services.lakeformation.model.ResourceType.DATABASE
  }
  case object TABLE extends zio.aws.lakeformation.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.ResourceType =
      software.amazon.awssdk.services.lakeformation.model.ResourceType.TABLE
  }
}
