package zio.aws.lakeformation.model
import scala.jdk.CollectionConverters._
sealed trait ResourceShareType {
  def unwrap
      : software.amazon.awssdk.services.lakeformation.model.ResourceShareType
}
object ResourceShareType {
  def wrap(
      value: software.amazon.awssdk.services.lakeformation.model.ResourceShareType
  ): zio.aws.lakeformation.model.ResourceShareType = value match {
    case software.amazon.awssdk.services.lakeformation.model.ResourceShareType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lakeformation.model.ResourceShareType.FOREIGN =>
      val r = FOREIGN
      r
    case software.amazon.awssdk.services.lakeformation.model.ResourceShareType.ALL =>
      val r = ALL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lakeformation.model.ResourceShareType {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.ResourceShareType =
      software.amazon.awssdk.services.lakeformation.model.ResourceShareType.UNKNOWN_TO_SDK_VERSION
  }
  case object FOREIGN extends zio.aws.lakeformation.model.ResourceShareType {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.ResourceShareType =
      software.amazon.awssdk.services.lakeformation.model.ResourceShareType.FOREIGN
  }
  case object ALL extends zio.aws.lakeformation.model.ResourceShareType {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.ResourceShareType =
      software.amazon.awssdk.services.lakeformation.model.ResourceShareType.ALL
  }
}
