package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.lakeformation.model.primitives.{QueryIdString, Token}
import scala.jdk.CollectionConverters._
final case class GetWorkUnitsResponse(
    nextToken: Optional[Token] = Optional.Absent,
    queryId: QueryIdString,
    workUnitRanges: Iterable[zio.aws.lakeformation.model.WorkUnitRange]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.GetWorkUnitsResponse = {
    import GetWorkUnitsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.GetWorkUnitsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .queryId(QueryIdString.unwrap(queryId): java.lang.String)
      .workUnitRanges(workUnitRanges.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.GetWorkUnitsResponse.ReadOnly =
    zio.aws.lakeformation.model.GetWorkUnitsResponse.wrap(buildAwsValue())
}
object GetWorkUnitsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.GetWorkUnitsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.GetWorkUnitsResponse =
      zio.aws.lakeformation.model.GetWorkUnitsResponse(
        nextToken.map(value => value),
        queryId,
        workUnitRanges.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[Token]
    def queryId: QueryIdString
    def workUnitRanges: List[zio.aws.lakeformation.model.WorkUnitRange.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getQueryId: ZIO[Any, Nothing, QueryIdString] = ZIO.succeed(queryId)
    def getWorkUnitRanges: ZIO[Any, Nothing, List[
      zio.aws.lakeformation.model.WorkUnitRange.ReadOnly
    ]] = ZIO.succeed(workUnitRanges)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.GetWorkUnitsResponse
  ) extends zio.aws.lakeformation.model.GetWorkUnitsResponse.ReadOnly {
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lakeformation.model.primitives.Token(value))
    override val queryId: QueryIdString =
      zio.aws.lakeformation.model.primitives.QueryIdString(impl.queryId())
    override val workUnitRanges
        : List[zio.aws.lakeformation.model.WorkUnitRange.ReadOnly] = impl
      .workUnitRanges()
      .asScala
      .map { item =>
        zio.aws.lakeformation.model.WorkUnitRange.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.GetWorkUnitsResponse
  ): zio.aws.lakeformation.model.GetWorkUnitsResponse.ReadOnly = new Wrapper(
    impl
  )
}
