package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.lakeformation.model.primitives.{BooleanNullable, CatalogIdString}
import scala.jdk.CollectionConverters._
final case class GetResourceLfTagsRequest(
    catalogId: Optional[CatalogIdString] = Optional.Absent,
    resource: zio.aws.lakeformation.model.Resource,
    showAssignedLFTags: Optional[BooleanNullable] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.GetResourceLfTagsRequest = {
    import GetResourceLfTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.GetResourceLfTagsRequest
      .builder()
      .optionallyWith(
        catalogId.map(value => CatalogIdString.unwrap(value): java.lang.String)
      )(_.catalogId)
      .resource(resource.buildAwsValue())
      .optionallyWith(
        showAssignedLFTags.map(value => value: java.lang.Boolean)
      )(_.showAssignedLFTags)
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.GetResourceLfTagsRequest.ReadOnly =
    zio.aws.lakeformation.model.GetResourceLfTagsRequest.wrap(buildAwsValue())
}
object GetResourceLfTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.GetResourceLfTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.GetResourceLfTagsRequest =
      zio.aws.lakeformation.model.GetResourceLfTagsRequest(
        catalogId.map(value => value),
        resource.asEditable,
        showAssignedLFTags.map(value => value)
      )
    def catalogId: Optional[CatalogIdString]
    def resource: zio.aws.lakeformation.model.Resource.ReadOnly
    def showAssignedLFTags: Optional[BooleanNullable]
    def getCatalogId: ZIO[Any, AwsError, CatalogIdString] =
      AwsError.unwrapOptionField("catalogId", catalogId)
    def getResource
        : ZIO[Any, Nothing, zio.aws.lakeformation.model.Resource.ReadOnly] =
      ZIO.succeed(resource)
    def getShowAssignedLFTags: ZIO[Any, AwsError, BooleanNullable] =
      AwsError.unwrapOptionField("showAssignedLFTags", showAssignedLFTags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.GetResourceLfTagsRequest
  ) extends zio.aws.lakeformation.model.GetResourceLfTagsRequest.ReadOnly {
    override val catalogId: Optional[CatalogIdString] = zio.aws.core.internal
      .optionalFromNullable(impl.catalogId())
      .map(value =>
        zio.aws.lakeformation.model.primitives.CatalogIdString(value)
      )
    override val resource: zio.aws.lakeformation.model.Resource.ReadOnly =
      zio.aws.lakeformation.model.Resource.wrap(impl.resource())
    override val showAssignedLFTags: Optional[BooleanNullable] =
      zio.aws.core.internal
        .optionalFromNullable(impl.showAssignedLFTags())
        .map(value => value: BooleanNullable)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.GetResourceLfTagsRequest
  ): zio.aws.lakeformation.model.GetResourceLfTagsRequest.ReadOnly =
    new Wrapper(impl)
}
