package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.lakeformation.model.primitives.DataLakePrincipalString
import scala.jdk.CollectionConverters._
final case class DataLakePrincipal(
    dataLakePrincipalIdentifier: Optional[DataLakePrincipalString] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.DataLakePrincipal = {
    import DataLakePrincipal.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.DataLakePrincipal
      .builder()
      .optionallyWith(
        dataLakePrincipalIdentifier.map(value =>
          DataLakePrincipalString.unwrap(value): java.lang.String
        )
      )(_.dataLakePrincipalIdentifier)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.DataLakePrincipal.ReadOnly =
    zio.aws.lakeformation.model.DataLakePrincipal.wrap(buildAwsValue())
}
object DataLakePrincipal {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.DataLakePrincipal
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.DataLakePrincipal =
      zio.aws.lakeformation.model
        .DataLakePrincipal(dataLakePrincipalIdentifier.map(value => value))
    def dataLakePrincipalIdentifier: Optional[DataLakePrincipalString]
    def getDataLakePrincipalIdentifier
        : ZIO[Any, AwsError, DataLakePrincipalString] =
      AwsError.unwrapOptionField(
        "dataLakePrincipalIdentifier",
        dataLakePrincipalIdentifier
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.DataLakePrincipal
  ) extends zio.aws.lakeformation.model.DataLakePrincipal.ReadOnly {
    override val dataLakePrincipalIdentifier
        : Optional[DataLakePrincipalString] = zio.aws.core.internal
      .optionalFromNullable(impl.dataLakePrincipalIdentifier())
      .map(value =>
        zio.aws.lakeformation.model.primitives.DataLakePrincipalString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.DataLakePrincipal
  ): zio.aws.lakeformation.model.DataLakePrincipal.ReadOnly = new Wrapper(impl)
}
