package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.lakeformation.model.primitives.Token
import scala.jdk.CollectionConverters._
final case class ListTableStorageOptimizersResponse(
    storageOptimizerList: Optional[
      Iterable[zio.aws.lakeformation.model.StorageOptimizer]
    ] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.ListTableStorageOptimizersResponse = {
    import ListTableStorageOptimizersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.ListTableStorageOptimizersResponse
      .builder()
      .optionallyWith(
        storageOptimizerList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.storageOptimizerList)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.ListTableStorageOptimizersResponse.ReadOnly =
    zio.aws.lakeformation.model.ListTableStorageOptimizersResponse
      .wrap(buildAwsValue())
}
object ListTableStorageOptimizersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.ListTableStorageOptimizersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lakeformation.model.ListTableStorageOptimizersResponse =
      zio.aws.lakeformation.model.ListTableStorageOptimizersResponse(
        storageOptimizerList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def storageOptimizerList
        : Optional[List[zio.aws.lakeformation.model.StorageOptimizer.ReadOnly]]
    def nextToken: Optional[Token]
    def getStorageOptimizerList: ZIO[Any, AwsError, List[
      zio.aws.lakeformation.model.StorageOptimizer.ReadOnly
    ]] =
      AwsError.unwrapOptionField("storageOptimizerList", storageOptimizerList)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.ListTableStorageOptimizersResponse
  ) extends zio.aws.lakeformation.model.ListTableStorageOptimizersResponse.ReadOnly {
    override val storageOptimizerList: Optional[
      List[zio.aws.lakeformation.model.StorageOptimizer.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.storageOptimizerList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lakeformation.model.StorageOptimizer.wrap(item)
        }.toList
      )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lakeformation.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.ListTableStorageOptimizersResponse
  ): zio.aws.lakeformation.model.ListTableStorageOptimizersResponse.ReadOnly =
    new Wrapper(impl)
}
