package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LFTagError(
    lfTag: Optional[zio.aws.lakeformation.model.LFTagPair] = Optional.Absent,
    error: Optional[zio.aws.lakeformation.model.ErrorDetail] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.LFTagError = {
    import LFTagError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.LFTagError
      .builder()
      .optionallyWith(lfTag.map(value => value.buildAwsValue()))(_.lfTag)
      .optionallyWith(error.map(value => value.buildAwsValue()))(_.error)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.LFTagError.ReadOnly =
    zio.aws.lakeformation.model.LFTagError.wrap(buildAwsValue())
}
object LFTagError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.LFTagError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.LFTagError =
      zio.aws.lakeformation.model.LFTagError(
        lfTag.map(value => value.asEditable),
        error.map(value => value.asEditable)
      )
    def lfTag: Optional[zio.aws.lakeformation.model.LFTagPair.ReadOnly]
    def error: Optional[zio.aws.lakeformation.model.ErrorDetail.ReadOnly]
    def getLfTag
        : ZIO[Any, AwsError, zio.aws.lakeformation.model.LFTagPair.ReadOnly] =
      AwsError.unwrapOptionField("lfTag", lfTag)
    def getError
        : ZIO[Any, AwsError, zio.aws.lakeformation.model.ErrorDetail.ReadOnly] =
      AwsError.unwrapOptionField("error", error)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.LFTagError
  ) extends zio.aws.lakeformation.model.LFTagError.ReadOnly {
    override val lfTag
        : Optional[zio.aws.lakeformation.model.LFTagPair.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lfTag())
        .map(value => zio.aws.lakeformation.model.LFTagPair.wrap(value))
    override val error
        : Optional[zio.aws.lakeformation.model.ErrorDetail.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.error())
        .map(value => zio.aws.lakeformation.model.ErrorDetail.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.LFTagError
  ): zio.aws.lakeformation.model.LFTagError.ReadOnly = new Wrapper(impl)
}
