package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.lakeformation.model.primitives.GetQueryStatisticsRequestQueryIdString
import scala.jdk.CollectionConverters._
final case class GetQueryStatisticsRequest(
    queryId: GetQueryStatisticsRequestQueryIdString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.GetQueryStatisticsRequest = {
    import GetQueryStatisticsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.GetQueryStatisticsRequest
      .builder()
      .queryId(
        GetQueryStatisticsRequestQueryIdString.unwrap(queryId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.GetQueryStatisticsRequest.ReadOnly =
    zio.aws.lakeformation.model.GetQueryStatisticsRequest.wrap(buildAwsValue())
}
object GetQueryStatisticsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.GetQueryStatisticsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.GetQueryStatisticsRequest =
      zio.aws.lakeformation.model.GetQueryStatisticsRequest(queryId)
    def queryId: GetQueryStatisticsRequestQueryIdString
    def getQueryId: ZIO[Any, Nothing, GetQueryStatisticsRequestQueryIdString] =
      ZIO.succeed(queryId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.GetQueryStatisticsRequest
  ) extends zio.aws.lakeformation.model.GetQueryStatisticsRequest.ReadOnly {
    override val queryId: GetQueryStatisticsRequestQueryIdString =
      zio.aws.lakeformation.model.primitives
        .GetQueryStatisticsRequestQueryIdString(impl.queryId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.GetQueryStatisticsRequest
  ): zio.aws.lakeformation.model.GetQueryStatisticsRequest.ReadOnly =
    new Wrapper(impl)
}
