package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.lakeformation.model.primitives.CatalogIdString
import scala.jdk.CollectionConverters._
final case class PutDataLakeSettingsRequest(
    catalogId: Optional[CatalogIdString] = Optional.Absent,
    dataLakeSettings: zio.aws.lakeformation.model.DataLakeSettings
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.PutDataLakeSettingsRequest = {
    import PutDataLakeSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.PutDataLakeSettingsRequest
      .builder()
      .optionallyWith(
        catalogId.map(value => CatalogIdString.unwrap(value): java.lang.String)
      )(_.catalogId)
      .dataLakeSettings(dataLakeSettings.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.PutDataLakeSettingsRequest.ReadOnly =
    zio.aws.lakeformation.model.PutDataLakeSettingsRequest.wrap(buildAwsValue())
}
object PutDataLakeSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.PutDataLakeSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.PutDataLakeSettingsRequest =
      zio.aws.lakeformation.model.PutDataLakeSettingsRequest(
        catalogId.map(value => value),
        dataLakeSettings.asEditable
      )
    def catalogId: Optional[CatalogIdString]
    def dataLakeSettings: zio.aws.lakeformation.model.DataLakeSettings.ReadOnly
    def getCatalogId: ZIO[Any, AwsError, CatalogIdString] =
      AwsError.unwrapOptionField("catalogId", catalogId)
    def getDataLakeSettings: ZIO[
      Any,
      Nothing,
      zio.aws.lakeformation.model.DataLakeSettings.ReadOnly
    ] = ZIO.succeed(dataLakeSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.PutDataLakeSettingsRequest
  ) extends zio.aws.lakeformation.model.PutDataLakeSettingsRequest.ReadOnly {
    override val catalogId: Optional[CatalogIdString] = zio.aws.core.internal
      .optionalFromNullable(impl.catalogId())
      .map(value =>
        zio.aws.lakeformation.model.primitives.CatalogIdString(value)
      )
    override val dataLakeSettings
        : zio.aws.lakeformation.model.DataLakeSettings.ReadOnly =
      zio.aws.lakeformation.model.DataLakeSettings.wrap(impl.dataLakeSettings())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.PutDataLakeSettingsRequest
  ): zio.aws.lakeformation.model.PutDataLakeSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
