package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PrincipalResourcePermissions(
    principal: Optional[zio.aws.lakeformation.model.DataLakePrincipal] =
      Optional.Absent,
    resource: Optional[zio.aws.lakeformation.model.Resource] = Optional.Absent,
    permissions: Optional[Iterable[zio.aws.lakeformation.model.Permission]] =
      Optional.Absent,
    permissionsWithGrantOption: Optional[
      Iterable[zio.aws.lakeformation.model.Permission]
    ] = Optional.Absent,
    additionalDetails: Optional[zio.aws.lakeformation.model.DetailsMap] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.PrincipalResourcePermissions = {
    import PrincipalResourcePermissions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.PrincipalResourcePermissions
      .builder()
      .optionallyWith(principal.map(value => value.buildAwsValue()))(
        _.principal
      )
      .optionallyWith(resource.map(value => value.buildAwsValue()))(_.resource)
      .optionallyWith(
        permissions.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.permissionsWithStrings)
      .optionallyWith(
        permissionsWithGrantOption.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.permissionsWithGrantOptionWithStrings)
      .optionallyWith(additionalDetails.map(value => value.buildAwsValue()))(
        _.additionalDetails
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.PrincipalResourcePermissions.ReadOnly =
    zio.aws.lakeformation.model.PrincipalResourcePermissions
      .wrap(buildAwsValue())
}
object PrincipalResourcePermissions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.PrincipalResourcePermissions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.PrincipalResourcePermissions =
      zio.aws.lakeformation.model.PrincipalResourcePermissions(
        principal.map(value => value.asEditable),
        resource.map(value => value.asEditable),
        permissions.map(value => value),
        permissionsWithGrantOption.map(value => value),
        additionalDetails.map(value => value.asEditable)
      )
    def principal
        : Optional[zio.aws.lakeformation.model.DataLakePrincipal.ReadOnly]
    def resource: Optional[zio.aws.lakeformation.model.Resource.ReadOnly]
    def permissions: Optional[List[zio.aws.lakeformation.model.Permission]]
    def permissionsWithGrantOption
        : Optional[List[zio.aws.lakeformation.model.Permission]]
    def additionalDetails
        : Optional[zio.aws.lakeformation.model.DetailsMap.ReadOnly]
    def getPrincipal: ZIO[
      Any,
      AwsError,
      zio.aws.lakeformation.model.DataLakePrincipal.ReadOnly
    ] = AwsError.unwrapOptionField("principal", principal)
    def getResource
        : ZIO[Any, AwsError, zio.aws.lakeformation.model.Resource.ReadOnly] =
      AwsError.unwrapOptionField("resource", resource)
    def getPermissions
        : ZIO[Any, AwsError, List[zio.aws.lakeformation.model.Permission]] =
      AwsError.unwrapOptionField("permissions", permissions)
    def getPermissionsWithGrantOption
        : ZIO[Any, AwsError, List[zio.aws.lakeformation.model.Permission]] =
      AwsError.unwrapOptionField(
        "permissionsWithGrantOption",
        permissionsWithGrantOption
      )
    def getAdditionalDetails
        : ZIO[Any, AwsError, zio.aws.lakeformation.model.DetailsMap.ReadOnly] =
      AwsError.unwrapOptionField("additionalDetails", additionalDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.PrincipalResourcePermissions
  ) extends zio.aws.lakeformation.model.PrincipalResourcePermissions.ReadOnly {
    override val principal
        : Optional[zio.aws.lakeformation.model.DataLakePrincipal.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.principal())
        .map(value => zio.aws.lakeformation.model.DataLakePrincipal.wrap(value))
    override val resource
        : Optional[zio.aws.lakeformation.model.Resource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resource())
        .map(value => zio.aws.lakeformation.model.Resource.wrap(value))
    override val permissions
        : Optional[List[zio.aws.lakeformation.model.Permission]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.permissions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lakeformation.model.Permission.wrap(item)
          }.toList
        )
    override val permissionsWithGrantOption
        : Optional[List[zio.aws.lakeformation.model.Permission]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.permissionsWithGrantOption())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lakeformation.model.Permission.wrap(item)
          }.toList
        )
    override val additionalDetails
        : Optional[zio.aws.lakeformation.model.DetailsMap.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.additionalDetails())
        .map(value => zio.aws.lakeformation.model.DetailsMap.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.PrincipalResourcePermissions
  ): zio.aws.lakeformation.model.PrincipalResourcePermissions.ReadOnly =
    new Wrapper(impl)
}
