package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PrincipalPermissions(
    principal: Optional[zio.aws.lakeformation.model.DataLakePrincipal] =
      Optional.Absent,
    permissions: Optional[Iterable[zio.aws.lakeformation.model.Permission]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.PrincipalPermissions = {
    import PrincipalPermissions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.PrincipalPermissions
      .builder()
      .optionallyWith(principal.map(value => value.buildAwsValue()))(
        _.principal
      )
      .optionallyWith(
        permissions.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.permissionsWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.PrincipalPermissions.ReadOnly =
    zio.aws.lakeformation.model.PrincipalPermissions.wrap(buildAwsValue())
}
object PrincipalPermissions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.PrincipalPermissions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.PrincipalPermissions =
      zio.aws.lakeformation.model.PrincipalPermissions(
        principal.map(value => value.asEditable),
        permissions.map(value => value)
      )
    def principal
        : Optional[zio.aws.lakeformation.model.DataLakePrincipal.ReadOnly]
    def permissions: Optional[List[zio.aws.lakeformation.model.Permission]]
    def getPrincipal: ZIO[
      Any,
      AwsError,
      zio.aws.lakeformation.model.DataLakePrincipal.ReadOnly
    ] = AwsError.unwrapOptionField("principal", principal)
    def getPermissions
        : ZIO[Any, AwsError, List[zio.aws.lakeformation.model.Permission]] =
      AwsError.unwrapOptionField("permissions", permissions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.PrincipalPermissions
  ) extends zio.aws.lakeformation.model.PrincipalPermissions.ReadOnly {
    override val principal
        : Optional[zio.aws.lakeformation.model.DataLakePrincipal.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.principal())
        .map(value => zio.aws.lakeformation.model.DataLakePrincipal.wrap(value))
    override val permissions
        : Optional[List[zio.aws.lakeformation.model.Permission]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.permissions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lakeformation.model.Permission.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.PrincipalPermissions
  ): zio.aws.lakeformation.model.PrincipalPermissions.ReadOnly = new Wrapper(
    impl
  )
}
