package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.lakeformation.model.primitives.Token
import scala.jdk.CollectionConverters._
final case class GetEffectivePermissionsForPathResponse(
    permissions: Optional[
      Iterable[zio.aws.lakeformation.model.PrincipalResourcePermissions]
    ] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.GetEffectivePermissionsForPathResponse = {
    import GetEffectivePermissionsForPathResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.GetEffectivePermissionsForPathResponse
      .builder()
      .optionallyWith(
        permissions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.permissions)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.GetEffectivePermissionsForPathResponse.ReadOnly =
    zio.aws.lakeformation.model.GetEffectivePermissionsForPathResponse
      .wrap(buildAwsValue())
}
object GetEffectivePermissionsForPathResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.GetEffectivePermissionsForPathResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lakeformation.model.GetEffectivePermissionsForPathResponse =
      zio.aws.lakeformation.model.GetEffectivePermissionsForPathResponse(
        permissions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def permissions: Optional[
      List[zio.aws.lakeformation.model.PrincipalResourcePermissions.ReadOnly]
    ]
    def nextToken: Optional[Token]
    def getPermissions: ZIO[Any, AwsError, List[
      zio.aws.lakeformation.model.PrincipalResourcePermissions.ReadOnly
    ]] = AwsError.unwrapOptionField("permissions", permissions)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.GetEffectivePermissionsForPathResponse
  ) extends zio.aws.lakeformation.model.GetEffectivePermissionsForPathResponse.ReadOnly {
    override val permissions: Optional[
      List[zio.aws.lakeformation.model.PrincipalResourcePermissions.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.permissions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lakeformation.model.PrincipalResourcePermissions.wrap(item)
        }.toList
      )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lakeformation.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.GetEffectivePermissionsForPathResponse
  ): zio.aws.lakeformation.model.GetEffectivePermissionsForPathResponse.ReadOnly =
    new Wrapper(impl)
}
