package zio.aws.lakeformation
import zio.aws.lakeformation.model.DescribeResourceResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.lakeformation.model.{
  DeleteLfTagRequest,
  ListTransactionsResponse,
  RemoveLfTagsFromResourceRequest,
  GetWorkUnitsRequest,
  TransactionDescription,
  DeregisterResourceRequest,
  GetTemporaryGluePartitionCredentialsRequest,
  BatchRevokePermissionsRequest,
  UpdateResourceResponse,
  LFTagPair,
  GetQueryStateResponse,
  GetTableObjectsRequest,
  GetWorkUnitResultsRequest,
  ExtendTransactionResponse,
  GetTemporaryGlueTableCredentialsRequest,
  UpdateTableObjectsResponse,
  StartQueryPlanningResponse,
  DeleteLfTagResponse,
  GrantPermissionsResponse,
  ResourceInfo,
  SearchTablesByLfTagsRequest,
  GetQueryStatisticsRequest,
  CreateLfTagRequest,
  ListTransactionsRequest,
  UpdateTableStorageOptimizerResponse,
  AddLfTagsToResourceRequest,
  ListResourcesResponse,
  ListDataCellsFilterResponse,
  ListLfTagsResponse,
  GetDataLakeSettingsResponse,
  WorkUnitRange,
  DeleteDataCellsFilterResponse,
  StartTransactionRequest,
  CommitTransactionRequest,
  TaggedTable,
  StartQueryPlanningRequest,
  RegisterResourceRequest,
  ListTableStorageOptimizersRequest,
  DeleteObjectsOnCancelResponse,
  DescribeTransactionResponse,
  DeleteDataCellsFilterRequest,
  ListPermissionsResponse,
  BatchRevokePermissionsResponse,
  StartTransactionResponse,
  BatchGrantPermissionsResponse,
  PartitionObjects,
  PutDataLakeSettingsRequest,
  GetLfTagResponse,
  ListResourcesRequest,
  UpdateTableObjectsRequest,
  SearchDatabasesByLfTagsResponse,
  GetEffectivePermissionsForPathResponse,
  UpdateLfTagResponse,
  GetResourceLfTagsResponse,
  StorageOptimizer,
  GetWorkUnitResultsResponse,
  ListTableStorageOptimizersResponse,
  UpdateLfTagRequest,
  PutDataLakeSettingsResponse,
  TaggedDatabase,
  ListDataCellsFilterRequest,
  ExtendTransactionRequest,
  GetEffectivePermissionsForPathRequest,
  ListLfTagsRequest,
  GetResourceLfTagsRequest,
  CancelTransactionRequest,
  ListPermissionsRequest,
  CommitTransactionResponse,
  DataCellsFilter,
  SearchDatabasesByLfTagsRequest,
  DeregisterResourceResponse,
  GetTemporaryGluePartitionCredentialsResponse,
  PrincipalResourcePermissions,
  CancelTransactionResponse,
  CreateDataCellsFilterResponse,
  GetTableObjectsResponse,
  GetQueryStatisticsResponse,
  SearchTablesByLfTagsResponse,
  RevokePermissionsResponse,
  RemoveLfTagsFromResourceResponse,
  UpdateTableStorageOptimizerRequest,
  CreateDataCellsFilterRequest,
  GetLfTagRequest,
  GetQueryStateRequest,
  GetWorkUnitsResponse,
  UpdateResourceRequest,
  CreateLfTagResponse,
  BatchGrantPermissionsRequest,
  RevokePermissionsRequest,
  DescribeResourceRequest,
  RegisterResourceResponse,
  DescribeResourceResponse,
  GrantPermissionsRequest,
  GetDataLakeSettingsRequest,
  DeleteObjectsOnCancelRequest,
  AddLfTagsToResourceResponse,
  DescribeTransactionRequest,
  GetTemporaryGlueTableCredentialsResponse
}
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import software.amazon.awssdk.services.lakeformation.{
  LakeFormationAsyncClientBuilder,
  LakeFormationAsyncClient
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, Task, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait LakeFormation extends AspectSupport[LakeFormation] {
  val api: LakeFormationAsyncClient
  def getResourceLFTags(
      request: zio.aws.lakeformation.model.GetResourceLfTagsRequest
  ): IO[
    AwsError,
    zio.aws.lakeformation.model.GetResourceLfTagsResponse.ReadOnly
  ]
  def listTransactions(
      request: zio.aws.lakeformation.model.ListTransactionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.lakeformation.model.TransactionDescription.ReadOnly
  ]
  def listTransactionsPaginated(
      request: zio.aws.lakeformation.model.ListTransactionsRequest
  ): IO[AwsError, zio.aws.lakeformation.model.ListTransactionsResponse.ReadOnly]
  def commitTransaction(
      request: zio.aws.lakeformation.model.CommitTransactionRequest
  ): IO[
    AwsError,
    zio.aws.lakeformation.model.CommitTransactionResponse.ReadOnly
  ]
  def removeLFTagsFromResource(
      request: zio.aws.lakeformation.model.RemoveLfTagsFromResourceRequest
  ): IO[
    AwsError,
    zio.aws.lakeformation.model.RemoveLfTagsFromResourceResponse.ReadOnly
  ]
  def updateResource(
      request: zio.aws.lakeformation.model.UpdateResourceRequest
  ): IO[AwsError, zio.aws.lakeformation.model.UpdateResourceResponse.ReadOnly]
  def listLFTags(
      request: zio.aws.lakeformation.model.ListLfTagsRequest
  ): ZStream[Any, AwsError, zio.aws.lakeformation.model.LFTagPair.ReadOnly]
  def listLFTagsPaginated(
      request: zio.aws.lakeformation.model.ListLfTagsRequest
  ): IO[AwsError, zio.aws.lakeformation.model.ListLfTagsResponse.ReadOnly]
  def revokePermissions(
      request: zio.aws.lakeformation.model.RevokePermissionsRequest
  ): IO[
    AwsError,
    zio.aws.lakeformation.model.RevokePermissionsResponse.ReadOnly
  ]
  def grantPermissions(
      request: zio.aws.lakeformation.model.GrantPermissionsRequest
  ): IO[AwsError, zio.aws.lakeformation.model.GrantPermissionsResponse.ReadOnly]
  def cancelTransaction(
      request: zio.aws.lakeformation.model.CancelTransactionRequest
  ): IO[
    AwsError,
    zio.aws.lakeformation.model.CancelTransactionResponse.ReadOnly
  ]
  def searchTablesByLFTags(
      request: zio.aws.lakeformation.model.SearchTablesByLfTagsRequest
  ): ZStream[Any, AwsError, zio.aws.lakeformation.model.TaggedTable.ReadOnly]
  def searchTablesByLFTagsPaginated(
      request: zio.aws.lakeformation.model.SearchTablesByLfTagsRequest
  ): IO[
    AwsError,
    zio.aws.lakeformation.model.SearchTablesByLfTagsResponse.ReadOnly
  ]
  def describeResource(
      request: zio.aws.lakeformation.model.DescribeResourceRequest
  ): IO[AwsError, ReadOnly]
  def deleteObjectsOnCancel(
      request: zio.aws.lakeformation.model.DeleteObjectsOnCancelRequest
  ): IO[
    AwsError,
    zio.aws.lakeformation.model.DeleteObjectsOnCancelResponse.ReadOnly
  ]
  def describeTransaction(
      request: zio.aws.lakeformation.model.DescribeTransactionRequest
  ): IO[
    AwsError,
    zio.aws.lakeformation.model.DescribeTransactionResponse.ReadOnly
  ]
  def getTemporaryGluePartitionCredentials(
      request: zio.aws.lakeformation.model.GetTemporaryGluePartitionCredentialsRequest
  ): IO[
    AwsError,
    zio.aws.lakeformation.model.GetTemporaryGluePartitionCredentialsResponse.ReadOnly
  ]
  def getDataLakeSettings(
      request: zio.aws.lakeformation.model.GetDataLakeSettingsRequest
  ): IO[
    AwsError,
    zio.aws.lakeformation.model.GetDataLakeSettingsResponse.ReadOnly
  ]
  def deleteLFTag(
      request: zio.aws.lakeformation.model.DeleteLfTagRequest
  ): IO[AwsError, zio.aws.lakeformation.model.DeleteLfTagResponse.ReadOnly]
  def updateTableObjects(
      request: zio.aws.lakeformation.model.UpdateTableObjectsRequest
  ): IO[
    AwsError,
    zio.aws.lakeformation.model.UpdateTableObjectsResponse.ReadOnly
  ]
  def startQueryPlanning(
      request: zio.aws.lakeformation.model.StartQueryPlanningRequest
  ): IO[
    AwsError,
    zio.aws.lakeformation.model.StartQueryPlanningResponse.ReadOnly
  ]
  def getWorkUnits(
      request: zio.aws.lakeformation.model.GetWorkUnitsRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.lakeformation.model.GetWorkUnitsResponse.ReadOnly,
    zio.aws.lakeformation.model.WorkUnitRange.ReadOnly
  ]]
  def getWorkUnitsPaginated(
      request: zio.aws.lakeformation.model.GetWorkUnitsRequest
  ): IO[AwsError, zio.aws.lakeformation.model.GetWorkUnitsResponse.ReadOnly]
  def searchDatabasesByLFTags(
      request: zio.aws.lakeformation.model.SearchDatabasesByLfTagsRequest
  ): ZStream[Any, AwsError, zio.aws.lakeformation.model.TaggedDatabase.ReadOnly]
  def searchDatabasesByLFTagsPaginated(
      request: zio.aws.lakeformation.model.SearchDatabasesByLfTagsRequest
  ): IO[
    AwsError,
    zio.aws.lakeformation.model.SearchDatabasesByLfTagsResponse.ReadOnly
  ]
  def extendTransaction(
      request: zio.aws.lakeformation.model.ExtendTransactionRequest
  ): IO[
    AwsError,
    zio.aws.lakeformation.model.ExtendTransactionResponse.ReadOnly
  ]
  def getWorkUnitResults(
      request: zio.aws.lakeformation.model.GetWorkUnitResultsRequest
  ): IO[AwsError, StreamingOutputResult[
    Any,
    zio.aws.lakeformation.model.GetWorkUnitResultsResponse.ReadOnly,
    Byte
  ]]
  def listResources(
      request: zio.aws.lakeformation.model.ListResourcesRequest
  ): ZStream[Any, AwsError, zio.aws.lakeformation.model.ResourceInfo.ReadOnly]
  def listResourcesPaginated(
      request: zio.aws.lakeformation.model.ListResourcesRequest
  ): IO[AwsError, zio.aws.lakeformation.model.ListResourcesResponse.ReadOnly]
  def putDataLakeSettings(
      request: zio.aws.lakeformation.model.PutDataLakeSettingsRequest
  ): IO[
    AwsError,
    zio.aws.lakeformation.model.PutDataLakeSettingsResponse.ReadOnly
  ]
  def deregisterResource(
      request: zio.aws.lakeformation.model.DeregisterResourceRequest
  ): IO[
    AwsError,
    zio.aws.lakeformation.model.DeregisterResourceResponse.ReadOnly
  ]
  def getTableObjects(
      request: zio.aws.lakeformation.model.GetTableObjectsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.lakeformation.model.PartitionObjects.ReadOnly
  ]
  def getTableObjectsPaginated(
      request: zio.aws.lakeformation.model.GetTableObjectsRequest
  ): IO[AwsError, zio.aws.lakeformation.model.GetTableObjectsResponse.ReadOnly]
  def createDataCellsFilter(
      request: zio.aws.lakeformation.model.CreateDataCellsFilterRequest
  ): IO[
    AwsError,
    zio.aws.lakeformation.model.CreateDataCellsFilterResponse.ReadOnly
  ]
  def listDataCellsFilter(
      request: zio.aws.lakeformation.model.ListDataCellsFilterRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.lakeformation.model.DataCellsFilter.ReadOnly
  ]
  def listDataCellsFilterPaginated(
      request: zio.aws.lakeformation.model.ListDataCellsFilterRequest
  ): IO[
    AwsError,
    zio.aws.lakeformation.model.ListDataCellsFilterResponse.ReadOnly
  ]
  def getTemporaryGlueTableCredentials(
      request: zio.aws.lakeformation.model.GetTemporaryGlueTableCredentialsRequest
  ): IO[
    AwsError,
    zio.aws.lakeformation.model.GetTemporaryGlueTableCredentialsResponse.ReadOnly
  ]
  def deleteDataCellsFilter(
      request: zio.aws.lakeformation.model.DeleteDataCellsFilterRequest
  ): IO[
    AwsError,
    zio.aws.lakeformation.model.DeleteDataCellsFilterResponse.ReadOnly
  ]
  def listPermissions(
      request: zio.aws.lakeformation.model.ListPermissionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.lakeformation.model.PrincipalResourcePermissions.ReadOnly
  ]
  def listPermissionsPaginated(
      request: zio.aws.lakeformation.model.ListPermissionsRequest
  ): IO[AwsError, zio.aws.lakeformation.model.ListPermissionsResponse.ReadOnly]
  def createLFTag(
      request: zio.aws.lakeformation.model.CreateLfTagRequest
  ): IO[AwsError, zio.aws.lakeformation.model.CreateLfTagResponse.ReadOnly]
  def updateLFTag(
      request: zio.aws.lakeformation.model.UpdateLfTagRequest
  ): IO[AwsError, zio.aws.lakeformation.model.UpdateLfTagResponse.ReadOnly]
  def updateTableStorageOptimizer(
      request: zio.aws.lakeformation.model.UpdateTableStorageOptimizerRequest
  ): IO[
    AwsError,
    zio.aws.lakeformation.model.UpdateTableStorageOptimizerResponse.ReadOnly
  ]
  def getQueryState(
      request: zio.aws.lakeformation.model.GetQueryStateRequest
  ): IO[AwsError, zio.aws.lakeformation.model.GetQueryStateResponse.ReadOnly]
  def batchGrantPermissions(
      request: zio.aws.lakeformation.model.BatchGrantPermissionsRequest
  ): IO[
    AwsError,
    zio.aws.lakeformation.model.BatchGrantPermissionsResponse.ReadOnly
  ]
  def addLFTagsToResource(
      request: zio.aws.lakeformation.model.AddLfTagsToResourceRequest
  ): IO[
    AwsError,
    zio.aws.lakeformation.model.AddLfTagsToResourceResponse.ReadOnly
  ]
  def startTransaction(
      request: zio.aws.lakeformation.model.StartTransactionRequest
  ): IO[AwsError, zio.aws.lakeformation.model.StartTransactionResponse.ReadOnly]
  def getQueryStatistics(
      request: zio.aws.lakeformation.model.GetQueryStatisticsRequest
  ): IO[
    AwsError,
    zio.aws.lakeformation.model.GetQueryStatisticsResponse.ReadOnly
  ]
  def getLFTag(
      request: zio.aws.lakeformation.model.GetLfTagRequest
  ): IO[AwsError, zio.aws.lakeformation.model.GetLfTagResponse.ReadOnly]
  def registerResource(
      request: zio.aws.lakeformation.model.RegisterResourceRequest
  ): IO[AwsError, zio.aws.lakeformation.model.RegisterResourceResponse.ReadOnly]
  def listTableStorageOptimizers(
      request: zio.aws.lakeformation.model.ListTableStorageOptimizersRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.lakeformation.model.StorageOptimizer.ReadOnly
  ]
  def listTableStorageOptimizersPaginated(
      request: zio.aws.lakeformation.model.ListTableStorageOptimizersRequest
  ): IO[
    AwsError,
    zio.aws.lakeformation.model.ListTableStorageOptimizersResponse.ReadOnly
  ]
  def getEffectivePermissionsForPath(
      request: zio.aws.lakeformation.model.GetEffectivePermissionsForPathRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.lakeformation.model.PrincipalResourcePermissions.ReadOnly
  ]
  def getEffectivePermissionsForPathPaginated(
      request: zio.aws.lakeformation.model.GetEffectivePermissionsForPathRequest
  ): IO[
    AwsError,
    zio.aws.lakeformation.model.GetEffectivePermissionsForPathResponse.ReadOnly
  ]
  def batchRevokePermissions(
      request: zio.aws.lakeformation.model.BatchRevokePermissionsRequest
  ): IO[
    AwsError,
    zio.aws.lakeformation.model.BatchRevokePermissionsResponse.ReadOnly
  ]
}
object LakeFormation {
  val live: ZLayer[AwsConfig, java.lang.Throwable, LakeFormation] = customized(
    identity
  )
  def customized(
      customization: LakeFormationAsyncClientBuilder => LakeFormationAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, LakeFormation] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: LakeFormationAsyncClientBuilder => LakeFormationAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, LakeFormation] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = LakeFormationAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[LakeFormationAsyncClient, LakeFormationAsyncClientBuilder](
        builder
      );
    b1 <- awsConfig.configureHttpClient[
      LakeFormationAsyncClient,
      LakeFormationAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new LakeFormationImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class LakeFormationImpl[R](
      override val api: LakeFormationAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends LakeFormation
      with AwsServiceBase[R] {
    override val serviceName: String = "LakeFormation"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): LakeFormationImpl[R1] = new LakeFormationImpl(api, newAspect, r)
    def getResourceLFTags(
        request: zio.aws.lakeformation.model.GetResourceLfTagsRequest
    ): IO[
      AwsError,
      zio.aws.lakeformation.model.GetResourceLfTagsResponse.ReadOnly
    ] =
      asyncRequestResponse[GetResourceLfTagsRequest, GetResourceLfTagsResponse](
        "getResourceLFTags",
        api.getResourceLFTags
      )(request.buildAwsValue())
        .map(zio.aws.lakeformation.model.GetResourceLfTagsResponse.wrap)
        .provideEnvironment(r)
    def listTransactions(
        request: zio.aws.lakeformation.model.ListTransactionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.lakeformation.model.TransactionDescription.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListTransactionsRequest,
      ListTransactionsResponse,
      TransactionDescription
    ](
      "listTransactions",
      api.listTransactions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.transactions().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.lakeformation.model.TransactionDescription.wrap(item)
      )
      .provideEnvironment(r)
    def listTransactionsPaginated(
        request: zio.aws.lakeformation.model.ListTransactionsRequest
    ): IO[
      AwsError,
      zio.aws.lakeformation.model.ListTransactionsResponse.ReadOnly
    ] = asyncRequestResponse[ListTransactionsRequest, ListTransactionsResponse](
      "listTransactions",
      api.listTransactions
    )(request.buildAwsValue())
      .map(zio.aws.lakeformation.model.ListTransactionsResponse.wrap)
      .provideEnvironment(r)
    def commitTransaction(
        request: zio.aws.lakeformation.model.CommitTransactionRequest
    ): IO[
      AwsError,
      zio.aws.lakeformation.model.CommitTransactionResponse.ReadOnly
    ] =
      asyncRequestResponse[CommitTransactionRequest, CommitTransactionResponse](
        "commitTransaction",
        api.commitTransaction
      )(request.buildAwsValue())
        .map(zio.aws.lakeformation.model.CommitTransactionResponse.wrap)
        .provideEnvironment(r)
    def removeLFTagsFromResource(
        request: zio.aws.lakeformation.model.RemoveLfTagsFromResourceRequest
    ): IO[
      AwsError,
      zio.aws.lakeformation.model.RemoveLfTagsFromResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      RemoveLfTagsFromResourceRequest,
      RemoveLfTagsFromResourceResponse
    ]("removeLFTagsFromResource", api.removeLFTagsFromResource)(
      request.buildAwsValue()
    ).map(zio.aws.lakeformation.model.RemoveLfTagsFromResourceResponse.wrap)
      .provideEnvironment(r)
    def updateResource(
        request: zio.aws.lakeformation.model.UpdateResourceRequest
    ): IO[
      AwsError,
      zio.aws.lakeformation.model.UpdateResourceResponse.ReadOnly
    ] = asyncRequestResponse[UpdateResourceRequest, UpdateResourceResponse](
      "updateResource",
      api.updateResource
    )(request.buildAwsValue())
      .map(zio.aws.lakeformation.model.UpdateResourceResponse.wrap)
      .provideEnvironment(r)
    def listLFTags(
        request: zio.aws.lakeformation.model.ListLfTagsRequest
    ): ZStream[Any, AwsError, zio.aws.lakeformation.model.LFTagPair.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListLfTagsRequest,
        ListLfTagsResponse,
        LFTagPair
      ](
        "listLFTags",
        api.listLFTags,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.lfTags().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.lakeformation.model.LFTagPair.wrap(item))
        .provideEnvironment(r)
    def listLFTagsPaginated(
        request: zio.aws.lakeformation.model.ListLfTagsRequest
    ): IO[AwsError, zio.aws.lakeformation.model.ListLfTagsResponse.ReadOnly] =
      asyncRequestResponse[ListLfTagsRequest, ListLfTagsResponse](
        "listLFTags",
        api.listLFTags
      )(request.buildAwsValue())
        .map(zio.aws.lakeformation.model.ListLfTagsResponse.wrap)
        .provideEnvironment(r)
    def revokePermissions(
        request: zio.aws.lakeformation.model.RevokePermissionsRequest
    ): IO[
      AwsError,
      zio.aws.lakeformation.model.RevokePermissionsResponse.ReadOnly
    ] =
      asyncRequestResponse[RevokePermissionsRequest, RevokePermissionsResponse](
        "revokePermissions",
        api.revokePermissions
      )(request.buildAwsValue())
        .map(zio.aws.lakeformation.model.RevokePermissionsResponse.wrap)
        .provideEnvironment(r)
    def grantPermissions(
        request: zio.aws.lakeformation.model.GrantPermissionsRequest
    ): IO[
      AwsError,
      zio.aws.lakeformation.model.GrantPermissionsResponse.ReadOnly
    ] = asyncRequestResponse[GrantPermissionsRequest, GrantPermissionsResponse](
      "grantPermissions",
      api.grantPermissions
    )(request.buildAwsValue())
      .map(zio.aws.lakeformation.model.GrantPermissionsResponse.wrap)
      .provideEnvironment(r)
    def cancelTransaction(
        request: zio.aws.lakeformation.model.CancelTransactionRequest
    ): IO[
      AwsError,
      zio.aws.lakeformation.model.CancelTransactionResponse.ReadOnly
    ] =
      asyncRequestResponse[CancelTransactionRequest, CancelTransactionResponse](
        "cancelTransaction",
        api.cancelTransaction
      )(request.buildAwsValue())
        .map(zio.aws.lakeformation.model.CancelTransactionResponse.wrap)
        .provideEnvironment(r)
    def searchTablesByLFTags(
        request: zio.aws.lakeformation.model.SearchTablesByLfTagsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.lakeformation.model.TaggedTable.ReadOnly
    ] = asyncSimplePaginatedRequest[
      SearchTablesByLfTagsRequest,
      SearchTablesByLfTagsResponse,
      TaggedTable
    ](
      "searchTablesByLFTags",
      api.searchTablesByLFTags,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.tableList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.lakeformation.model.TaggedTable.wrap(item))
      .provideEnvironment(r)
    def searchTablesByLFTagsPaginated(
        request: zio.aws.lakeformation.model.SearchTablesByLfTagsRequest
    ): IO[
      AwsError,
      zio.aws.lakeformation.model.SearchTablesByLfTagsResponse.ReadOnly
    ] = asyncRequestResponse[
      SearchTablesByLfTagsRequest,
      SearchTablesByLfTagsResponse
    ]("searchTablesByLFTags", api.searchTablesByLFTags)(request.buildAwsValue())
      .map(zio.aws.lakeformation.model.SearchTablesByLfTagsResponse.wrap)
      .provideEnvironment(r)
    def describeResource(
        request: zio.aws.lakeformation.model.DescribeResourceRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[DescribeResourceRequest, DescribeResourceResponse](
        "describeResource",
        api.describeResource
      )(request.buildAwsValue())
        .map(zio.aws.lakeformation.model.DescribeResourceResponse.wrap)
        .provideEnvironment(r)
    def deleteObjectsOnCancel(
        request: zio.aws.lakeformation.model.DeleteObjectsOnCancelRequest
    ): IO[
      AwsError,
      zio.aws.lakeformation.model.DeleteObjectsOnCancelResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteObjectsOnCancelRequest,
      DeleteObjectsOnCancelResponse
    ]("deleteObjectsOnCancel", api.deleteObjectsOnCancel)(
      request.buildAwsValue()
    ).map(zio.aws.lakeformation.model.DeleteObjectsOnCancelResponse.wrap)
      .provideEnvironment(r)
    def describeTransaction(
        request: zio.aws.lakeformation.model.DescribeTransactionRequest
    ): IO[
      AwsError,
      zio.aws.lakeformation.model.DescribeTransactionResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeTransactionRequest,
      DescribeTransactionResponse
    ]("describeTransaction", api.describeTransaction)(request.buildAwsValue())
      .map(zio.aws.lakeformation.model.DescribeTransactionResponse.wrap)
      .provideEnvironment(r)
    def getTemporaryGluePartitionCredentials(
        request: zio.aws.lakeformation.model.GetTemporaryGluePartitionCredentialsRequest
    ): IO[
      AwsError,
      zio.aws.lakeformation.model.GetTemporaryGluePartitionCredentialsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetTemporaryGluePartitionCredentialsRequest,
      GetTemporaryGluePartitionCredentialsResponse
    ](
      "getTemporaryGluePartitionCredentials",
      api.getTemporaryGluePartitionCredentials
    )(request.buildAwsValue())
      .map(
        zio.aws.lakeformation.model.GetTemporaryGluePartitionCredentialsResponse.wrap
      )
      .provideEnvironment(r)
    def getDataLakeSettings(
        request: zio.aws.lakeformation.model.GetDataLakeSettingsRequest
    ): IO[
      AwsError,
      zio.aws.lakeformation.model.GetDataLakeSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetDataLakeSettingsRequest,
      GetDataLakeSettingsResponse
    ]("getDataLakeSettings", api.getDataLakeSettings)(request.buildAwsValue())
      .map(zio.aws.lakeformation.model.GetDataLakeSettingsResponse.wrap)
      .provideEnvironment(r)
    def deleteLFTag(
        request: zio.aws.lakeformation.model.DeleteLfTagRequest
    ): IO[AwsError, zio.aws.lakeformation.model.DeleteLfTagResponse.ReadOnly] =
      asyncRequestResponse[DeleteLfTagRequest, DeleteLfTagResponse](
        "deleteLFTag",
        api.deleteLFTag
      )(request.buildAwsValue())
        .map(zio.aws.lakeformation.model.DeleteLfTagResponse.wrap)
        .provideEnvironment(r)
    def updateTableObjects(
        request: zio.aws.lakeformation.model.UpdateTableObjectsRequest
    ): IO[
      AwsError,
      zio.aws.lakeformation.model.UpdateTableObjectsResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateTableObjectsRequest,
      UpdateTableObjectsResponse
    ]("updateTableObjects", api.updateTableObjects)(request.buildAwsValue())
      .map(zio.aws.lakeformation.model.UpdateTableObjectsResponse.wrap)
      .provideEnvironment(r)
    def startQueryPlanning(
        request: zio.aws.lakeformation.model.StartQueryPlanningRequest
    ): IO[
      AwsError,
      zio.aws.lakeformation.model.StartQueryPlanningResponse.ReadOnly
    ] = asyncRequestResponse[
      StartQueryPlanningRequest,
      StartQueryPlanningResponse
    ]("startQueryPlanning", api.startQueryPlanning)(request.buildAwsValue())
      .map(zio.aws.lakeformation.model.StartQueryPlanningResponse.wrap)
      .provideEnvironment(r)
    def getWorkUnits(
        request: zio.aws.lakeformation.model.GetWorkUnitsRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.lakeformation.model.GetWorkUnitsResponse.ReadOnly,
      zio.aws.lakeformation.model.WorkUnitRange.ReadOnly
    ]] = asyncPaginatedRequest[
      GetWorkUnitsRequest,
      GetWorkUnitsResponse,
      WorkUnitRange
    ](
      "getWorkUnits",
      api.getWorkUnits,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.workUnitRanges().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.lakeformation.model.GetWorkUnitsResponse.wrap)
          .mapOutput(
            _.map(item => zio.aws.lakeformation.model.WorkUnitRange.wrap(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def getWorkUnitsPaginated(
        request: zio.aws.lakeformation.model.GetWorkUnitsRequest
    ): IO[AwsError, zio.aws.lakeformation.model.GetWorkUnitsResponse.ReadOnly] =
      asyncRequestResponse[GetWorkUnitsRequest, GetWorkUnitsResponse](
        "getWorkUnits",
        api.getWorkUnits
      )(request.buildAwsValue())
        .map(zio.aws.lakeformation.model.GetWorkUnitsResponse.wrap)
        .provideEnvironment(r)
    def searchDatabasesByLFTags(
        request: zio.aws.lakeformation.model.SearchDatabasesByLfTagsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.lakeformation.model.TaggedDatabase.ReadOnly
    ] = asyncSimplePaginatedRequest[
      SearchDatabasesByLfTagsRequest,
      SearchDatabasesByLfTagsResponse,
      TaggedDatabase
    ](
      "searchDatabasesByLFTags",
      api.searchDatabasesByLFTags,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.databaseList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.lakeformation.model.TaggedDatabase.wrap(item))
      .provideEnvironment(r)
    def searchDatabasesByLFTagsPaginated(
        request: zio.aws.lakeformation.model.SearchDatabasesByLfTagsRequest
    ): IO[
      AwsError,
      zio.aws.lakeformation.model.SearchDatabasesByLfTagsResponse.ReadOnly
    ] = asyncRequestResponse[
      SearchDatabasesByLfTagsRequest,
      SearchDatabasesByLfTagsResponse
    ]("searchDatabasesByLFTags", api.searchDatabasesByLFTags)(
      request.buildAwsValue()
    ).map(zio.aws.lakeformation.model.SearchDatabasesByLfTagsResponse.wrap)
      .provideEnvironment(r)
    def extendTransaction(
        request: zio.aws.lakeformation.model.ExtendTransactionRequest
    ): IO[
      AwsError,
      zio.aws.lakeformation.model.ExtendTransactionResponse.ReadOnly
    ] =
      asyncRequestResponse[ExtendTransactionRequest, ExtendTransactionResponse](
        "extendTransaction",
        api.extendTransaction
      )(request.buildAwsValue())
        .map(zio.aws.lakeformation.model.ExtendTransactionResponse.wrap)
        .provideEnvironment(r)
    def getWorkUnitResults(
        request: zio.aws.lakeformation.model.GetWorkUnitResultsRequest
    ): IO[AwsError, StreamingOutputResult[
      Any,
      zio.aws.lakeformation.model.GetWorkUnitResultsResponse.ReadOnly,
      Byte
    ]] = asyncRequestOutputStream[
      GetWorkUnitResultsRequest,
      GetWorkUnitResultsResponse
    ](
      "getWorkUnitResults",
      api.getWorkUnitResults[Task[
        StreamingOutputResult[R, GetWorkUnitResultsResponse, Byte]
      ]]
    )(request.buildAwsValue())
      .map(
        _.mapResponse(
          zio.aws.lakeformation.model.GetWorkUnitResultsResponse.wrap
        ).provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listResources(
        request: zio.aws.lakeformation.model.ListResourcesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.lakeformation.model.ResourceInfo.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListResourcesRequest,
      ListResourcesResponse,
      ResourceInfo
    ](
      "listResources",
      api.listResources,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.resourceInfoList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.lakeformation.model.ResourceInfo.wrap(item))
      .provideEnvironment(r)
    def listResourcesPaginated(
        request: zio.aws.lakeformation.model.ListResourcesRequest
    ): IO[
      AwsError,
      zio.aws.lakeformation.model.ListResourcesResponse.ReadOnly
    ] = asyncRequestResponse[ListResourcesRequest, ListResourcesResponse](
      "listResources",
      api.listResources
    )(request.buildAwsValue())
      .map(zio.aws.lakeformation.model.ListResourcesResponse.wrap)
      .provideEnvironment(r)
    def putDataLakeSettings(
        request: zio.aws.lakeformation.model.PutDataLakeSettingsRequest
    ): IO[
      AwsError,
      zio.aws.lakeformation.model.PutDataLakeSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      PutDataLakeSettingsRequest,
      PutDataLakeSettingsResponse
    ]("putDataLakeSettings", api.putDataLakeSettings)(request.buildAwsValue())
      .map(zio.aws.lakeformation.model.PutDataLakeSettingsResponse.wrap)
      .provideEnvironment(r)
    def deregisterResource(
        request: zio.aws.lakeformation.model.DeregisterResourceRequest
    ): IO[
      AwsError,
      zio.aws.lakeformation.model.DeregisterResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      DeregisterResourceRequest,
      DeregisterResourceResponse
    ]("deregisterResource", api.deregisterResource)(request.buildAwsValue())
      .map(zio.aws.lakeformation.model.DeregisterResourceResponse.wrap)
      .provideEnvironment(r)
    def getTableObjects(
        request: zio.aws.lakeformation.model.GetTableObjectsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.lakeformation.model.PartitionObjects.ReadOnly
    ] = asyncSimplePaginatedRequest[
      GetTableObjectsRequest,
      GetTableObjectsResponse,
      PartitionObjects
    ](
      "getTableObjects",
      api.getTableObjects,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.objects().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.lakeformation.model.PartitionObjects.wrap(item))
      .provideEnvironment(r)
    def getTableObjectsPaginated(
        request: zio.aws.lakeformation.model.GetTableObjectsRequest
    ): IO[
      AwsError,
      zio.aws.lakeformation.model.GetTableObjectsResponse.ReadOnly
    ] = asyncRequestResponse[GetTableObjectsRequest, GetTableObjectsResponse](
      "getTableObjects",
      api.getTableObjects
    )(request.buildAwsValue())
      .map(zio.aws.lakeformation.model.GetTableObjectsResponse.wrap)
      .provideEnvironment(r)
    def createDataCellsFilter(
        request: zio.aws.lakeformation.model.CreateDataCellsFilterRequest
    ): IO[
      AwsError,
      zio.aws.lakeformation.model.CreateDataCellsFilterResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateDataCellsFilterRequest,
      CreateDataCellsFilterResponse
    ]("createDataCellsFilter", api.createDataCellsFilter)(
      request.buildAwsValue()
    ).map(zio.aws.lakeformation.model.CreateDataCellsFilterResponse.wrap)
      .provideEnvironment(r)
    def listDataCellsFilter(
        request: zio.aws.lakeformation.model.ListDataCellsFilterRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.lakeformation.model.DataCellsFilter.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListDataCellsFilterRequest,
      ListDataCellsFilterResponse,
      DataCellsFilter
    ](
      "listDataCellsFilter",
      api.listDataCellsFilter,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.dataCellsFilters().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.lakeformation.model.DataCellsFilter.wrap(item))
      .provideEnvironment(r)
    def listDataCellsFilterPaginated(
        request: zio.aws.lakeformation.model.ListDataCellsFilterRequest
    ): IO[
      AwsError,
      zio.aws.lakeformation.model.ListDataCellsFilterResponse.ReadOnly
    ] = asyncRequestResponse[
      ListDataCellsFilterRequest,
      ListDataCellsFilterResponse
    ]("listDataCellsFilter", api.listDataCellsFilter)(request.buildAwsValue())
      .map(zio.aws.lakeformation.model.ListDataCellsFilterResponse.wrap)
      .provideEnvironment(r)
    def getTemporaryGlueTableCredentials(
        request: zio.aws.lakeformation.model.GetTemporaryGlueTableCredentialsRequest
    ): IO[
      AwsError,
      zio.aws.lakeformation.model.GetTemporaryGlueTableCredentialsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetTemporaryGlueTableCredentialsRequest,
      GetTemporaryGlueTableCredentialsResponse
    ]("getTemporaryGlueTableCredentials", api.getTemporaryGlueTableCredentials)(
      request.buildAwsValue()
    ).map(
      zio.aws.lakeformation.model.GetTemporaryGlueTableCredentialsResponse.wrap
    ).provideEnvironment(r)
    def deleteDataCellsFilter(
        request: zio.aws.lakeformation.model.DeleteDataCellsFilterRequest
    ): IO[
      AwsError,
      zio.aws.lakeformation.model.DeleteDataCellsFilterResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteDataCellsFilterRequest,
      DeleteDataCellsFilterResponse
    ]("deleteDataCellsFilter", api.deleteDataCellsFilter)(
      request.buildAwsValue()
    ).map(zio.aws.lakeformation.model.DeleteDataCellsFilterResponse.wrap)
      .provideEnvironment(r)
    def listPermissions(
        request: zio.aws.lakeformation.model.ListPermissionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.lakeformation.model.PrincipalResourcePermissions.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListPermissionsRequest,
      ListPermissionsResponse,
      PrincipalResourcePermissions
    ](
      "listPermissions",
      api.listPermissions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.principalResourcePermissions().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.lakeformation.model.PrincipalResourcePermissions.wrap(item)
      )
      .provideEnvironment(r)
    def listPermissionsPaginated(
        request: zio.aws.lakeformation.model.ListPermissionsRequest
    ): IO[
      AwsError,
      zio.aws.lakeformation.model.ListPermissionsResponse.ReadOnly
    ] = asyncRequestResponse[ListPermissionsRequest, ListPermissionsResponse](
      "listPermissions",
      api.listPermissions
    )(request.buildAwsValue())
      .map(zio.aws.lakeformation.model.ListPermissionsResponse.wrap)
      .provideEnvironment(r)
    def createLFTag(
        request: zio.aws.lakeformation.model.CreateLfTagRequest
    ): IO[AwsError, zio.aws.lakeformation.model.CreateLfTagResponse.ReadOnly] =
      asyncRequestResponse[CreateLfTagRequest, CreateLfTagResponse](
        "createLFTag",
        api.createLFTag
      )(request.buildAwsValue())
        .map(zio.aws.lakeformation.model.CreateLfTagResponse.wrap)
        .provideEnvironment(r)
    def updateLFTag(
        request: zio.aws.lakeformation.model.UpdateLfTagRequest
    ): IO[AwsError, zio.aws.lakeformation.model.UpdateLfTagResponse.ReadOnly] =
      asyncRequestResponse[UpdateLfTagRequest, UpdateLfTagResponse](
        "updateLFTag",
        api.updateLFTag
      )(request.buildAwsValue())
        .map(zio.aws.lakeformation.model.UpdateLfTagResponse.wrap)
        .provideEnvironment(r)
    def updateTableStorageOptimizer(
        request: zio.aws.lakeformation.model.UpdateTableStorageOptimizerRequest
    ): IO[
      AwsError,
      zio.aws.lakeformation.model.UpdateTableStorageOptimizerResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateTableStorageOptimizerRequest,
      UpdateTableStorageOptimizerResponse
    ]("updateTableStorageOptimizer", api.updateTableStorageOptimizer)(
      request.buildAwsValue()
    ).map(zio.aws.lakeformation.model.UpdateTableStorageOptimizerResponse.wrap)
      .provideEnvironment(r)
    def getQueryState(
        request: zio.aws.lakeformation.model.GetQueryStateRequest
    ): IO[
      AwsError,
      zio.aws.lakeformation.model.GetQueryStateResponse.ReadOnly
    ] = asyncRequestResponse[GetQueryStateRequest, GetQueryStateResponse](
      "getQueryState",
      api.getQueryState
    )(request.buildAwsValue())
      .map(zio.aws.lakeformation.model.GetQueryStateResponse.wrap)
      .provideEnvironment(r)
    def batchGrantPermissions(
        request: zio.aws.lakeformation.model.BatchGrantPermissionsRequest
    ): IO[
      AwsError,
      zio.aws.lakeformation.model.BatchGrantPermissionsResponse.ReadOnly
    ] = asyncRequestResponse[
      BatchGrantPermissionsRequest,
      BatchGrantPermissionsResponse
    ]("batchGrantPermissions", api.batchGrantPermissions)(
      request.buildAwsValue()
    ).map(zio.aws.lakeformation.model.BatchGrantPermissionsResponse.wrap)
      .provideEnvironment(r)
    def addLFTagsToResource(
        request: zio.aws.lakeformation.model.AddLfTagsToResourceRequest
    ): IO[
      AwsError,
      zio.aws.lakeformation.model.AddLfTagsToResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      AddLfTagsToResourceRequest,
      AddLfTagsToResourceResponse
    ]("addLFTagsToResource", api.addLFTagsToResource)(request.buildAwsValue())
      .map(zio.aws.lakeformation.model.AddLfTagsToResourceResponse.wrap)
      .provideEnvironment(r)
    def startTransaction(
        request: zio.aws.lakeformation.model.StartTransactionRequest
    ): IO[
      AwsError,
      zio.aws.lakeformation.model.StartTransactionResponse.ReadOnly
    ] = asyncRequestResponse[StartTransactionRequest, StartTransactionResponse](
      "startTransaction",
      api.startTransaction
    )(request.buildAwsValue())
      .map(zio.aws.lakeformation.model.StartTransactionResponse.wrap)
      .provideEnvironment(r)
    def getQueryStatistics(
        request: zio.aws.lakeformation.model.GetQueryStatisticsRequest
    ): IO[
      AwsError,
      zio.aws.lakeformation.model.GetQueryStatisticsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetQueryStatisticsRequest,
      GetQueryStatisticsResponse
    ]("getQueryStatistics", api.getQueryStatistics)(request.buildAwsValue())
      .map(zio.aws.lakeformation.model.GetQueryStatisticsResponse.wrap)
      .provideEnvironment(r)
    def getLFTag(
        request: zio.aws.lakeformation.model.GetLfTagRequest
    ): IO[AwsError, zio.aws.lakeformation.model.GetLfTagResponse.ReadOnly] =
      asyncRequestResponse[GetLfTagRequest, GetLfTagResponse](
        "getLFTag",
        api.getLFTag
      )(request.buildAwsValue())
        .map(zio.aws.lakeformation.model.GetLfTagResponse.wrap)
        .provideEnvironment(r)
    def registerResource(
        request: zio.aws.lakeformation.model.RegisterResourceRequest
    ): IO[
      AwsError,
      zio.aws.lakeformation.model.RegisterResourceResponse.ReadOnly
    ] = asyncRequestResponse[RegisterResourceRequest, RegisterResourceResponse](
      "registerResource",
      api.registerResource
    )(request.buildAwsValue())
      .map(zio.aws.lakeformation.model.RegisterResourceResponse.wrap)
      .provideEnvironment(r)
    def listTableStorageOptimizers(
        request: zio.aws.lakeformation.model.ListTableStorageOptimizersRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.lakeformation.model.StorageOptimizer.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListTableStorageOptimizersRequest,
      ListTableStorageOptimizersResponse,
      StorageOptimizer
    ](
      "listTableStorageOptimizers",
      api.listTableStorageOptimizers,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.storageOptimizerList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.lakeformation.model.StorageOptimizer.wrap(item))
      .provideEnvironment(r)
    def listTableStorageOptimizersPaginated(
        request: zio.aws.lakeformation.model.ListTableStorageOptimizersRequest
    ): IO[
      AwsError,
      zio.aws.lakeformation.model.ListTableStorageOptimizersResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTableStorageOptimizersRequest,
      ListTableStorageOptimizersResponse
    ]("listTableStorageOptimizers", api.listTableStorageOptimizers)(
      request.buildAwsValue()
    ).map(zio.aws.lakeformation.model.ListTableStorageOptimizersResponse.wrap)
      .provideEnvironment(r)
    def getEffectivePermissionsForPath(
        request: zio.aws.lakeformation.model.GetEffectivePermissionsForPathRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.lakeformation.model.PrincipalResourcePermissions.ReadOnly
    ] = asyncSimplePaginatedRequest[
      GetEffectivePermissionsForPathRequest,
      GetEffectivePermissionsForPathResponse,
      PrincipalResourcePermissions
    ](
      "getEffectivePermissionsForPath",
      api.getEffectivePermissionsForPath,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.permissions().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.lakeformation.model.PrincipalResourcePermissions.wrap(item)
      )
      .provideEnvironment(r)
    def getEffectivePermissionsForPathPaginated(
        request: zio.aws.lakeformation.model.GetEffectivePermissionsForPathRequest
    ): IO[
      AwsError,
      zio.aws.lakeformation.model.GetEffectivePermissionsForPathResponse.ReadOnly
    ] = asyncRequestResponse[
      GetEffectivePermissionsForPathRequest,
      GetEffectivePermissionsForPathResponse
    ]("getEffectivePermissionsForPath", api.getEffectivePermissionsForPath)(
      request.buildAwsValue()
    ).map(
      zio.aws.lakeformation.model.GetEffectivePermissionsForPathResponse.wrap
    ).provideEnvironment(r)
    def batchRevokePermissions(
        request: zio.aws.lakeformation.model.BatchRevokePermissionsRequest
    ): IO[
      AwsError,
      zio.aws.lakeformation.model.BatchRevokePermissionsResponse.ReadOnly
    ] = asyncRequestResponse[
      BatchRevokePermissionsRequest,
      BatchRevokePermissionsResponse
    ]("batchRevokePermissions", api.batchRevokePermissions)(
      request.buildAwsValue()
    ).map(zio.aws.lakeformation.model.BatchRevokePermissionsResponse.wrap)
      .provideEnvironment(r)
  }
  def getResourceLFTags(
      request: zio.aws.lakeformation.model.GetResourceLfTagsRequest
  ): ZIO[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.GetResourceLfTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getResourceLFTags(request))
  def listTransactions(
      request: zio.aws.lakeformation.model.ListTransactionsRequest
  ): ZStream[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.TransactionDescription.ReadOnly
  ] = ZStream.serviceWithStream(_.listTransactions(request))
  def listTransactionsPaginated(
      request: zio.aws.lakeformation.model.ListTransactionsRequest
  ): ZIO[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.ListTransactionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTransactionsPaginated(request))
  def commitTransaction(
      request: zio.aws.lakeformation.model.CommitTransactionRequest
  ): ZIO[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.CommitTransactionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.commitTransaction(request))
  def removeLFTagsFromResource(
      request: zio.aws.lakeformation.model.RemoveLfTagsFromResourceRequest
  ): ZIO[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.RemoveLfTagsFromResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.removeLFTagsFromResource(request))
  def updateResource(
      request: zio.aws.lakeformation.model.UpdateResourceRequest
  ): ZIO[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.UpdateResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateResource(request))
  def listLFTags(
      request: zio.aws.lakeformation.model.ListLfTagsRequest
  ): ZStream[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.LFTagPair.ReadOnly
  ] = ZStream.serviceWithStream(_.listLFTags(request))
  def listLFTagsPaginated(
      request: zio.aws.lakeformation.model.ListLfTagsRequest
  ): ZIO[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.ListLfTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listLFTagsPaginated(request))
  def revokePermissions(
      request: zio.aws.lakeformation.model.RevokePermissionsRequest
  ): ZIO[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.RevokePermissionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.revokePermissions(request))
  def grantPermissions(
      request: zio.aws.lakeformation.model.GrantPermissionsRequest
  ): ZIO[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.GrantPermissionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.grantPermissions(request))
  def cancelTransaction(
      request: zio.aws.lakeformation.model.CancelTransactionRequest
  ): ZIO[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.CancelTransactionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelTransaction(request))
  def searchTablesByLFTags(
      request: zio.aws.lakeformation.model.SearchTablesByLfTagsRequest
  ): ZStream[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.TaggedTable.ReadOnly
  ] = ZStream.serviceWithStream(_.searchTablesByLFTags(request))
  def searchTablesByLFTagsPaginated(
      request: zio.aws.lakeformation.model.SearchTablesByLfTagsRequest
  ): ZIO[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.SearchTablesByLfTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchTablesByLFTagsPaginated(request))
  def describeResource(
      request: zio.aws.lakeformation.model.DescribeResourceRequest
  ): ZIO[zio.aws.lakeformation.LakeFormation, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.describeResource(request))
  def deleteObjectsOnCancel(
      request: zio.aws.lakeformation.model.DeleteObjectsOnCancelRequest
  ): ZIO[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.DeleteObjectsOnCancelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteObjectsOnCancel(request))
  def describeTransaction(
      request: zio.aws.lakeformation.model.DescribeTransactionRequest
  ): ZIO[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.DescribeTransactionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTransaction(request))
  def getTemporaryGluePartitionCredentials(
      request: zio.aws.lakeformation.model.GetTemporaryGluePartitionCredentialsRequest
  ): ZIO[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.GetTemporaryGluePartitionCredentialsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getTemporaryGluePartitionCredentials(request))
  def getDataLakeSettings(
      request: zio.aws.lakeformation.model.GetDataLakeSettingsRequest
  ): ZIO[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.GetDataLakeSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDataLakeSettings(request))
  def deleteLFTag(request: zio.aws.lakeformation.model.DeleteLfTagRequest): ZIO[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.DeleteLfTagResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteLFTag(request))
  def updateTableObjects(
      request: zio.aws.lakeformation.model.UpdateTableObjectsRequest
  ): ZIO[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.UpdateTableObjectsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateTableObjects(request))
  def startQueryPlanning(
      request: zio.aws.lakeformation.model.StartQueryPlanningRequest
  ): ZIO[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.StartQueryPlanningResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startQueryPlanning(request))
  def getWorkUnits(
      request: zio.aws.lakeformation.model.GetWorkUnitsRequest
  ): ZIO[zio.aws.lakeformation.LakeFormation, AwsError, StreamingOutputResult[
    Any,
    zio.aws.lakeformation.model.GetWorkUnitsResponse.ReadOnly,
    zio.aws.lakeformation.model.WorkUnitRange.ReadOnly
  ]] = ZIO.serviceWithZIO(_.getWorkUnits(request))
  def getWorkUnitsPaginated(
      request: zio.aws.lakeformation.model.GetWorkUnitsRequest
  ): ZIO[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.GetWorkUnitsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getWorkUnitsPaginated(request))
  def searchDatabasesByLFTags(
      request: zio.aws.lakeformation.model.SearchDatabasesByLfTagsRequest
  ): ZStream[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.TaggedDatabase.ReadOnly
  ] = ZStream.serviceWithStream(_.searchDatabasesByLFTags(request))
  def searchDatabasesByLFTagsPaginated(
      request: zio.aws.lakeformation.model.SearchDatabasesByLfTagsRequest
  ): ZIO[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.SearchDatabasesByLfTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchDatabasesByLFTagsPaginated(request))
  def extendTransaction(
      request: zio.aws.lakeformation.model.ExtendTransactionRequest
  ): ZIO[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.ExtendTransactionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.extendTransaction(request))
  def getWorkUnitResults(
      request: zio.aws.lakeformation.model.GetWorkUnitResultsRequest
  ): ZIO[zio.aws.lakeformation.LakeFormation, AwsError, StreamingOutputResult[
    Any,
    zio.aws.lakeformation.model.GetWorkUnitResultsResponse.ReadOnly,
    Byte
  ]] = ZIO.serviceWithZIO(_.getWorkUnitResults(request))
  def listResources(
      request: zio.aws.lakeformation.model.ListResourcesRequest
  ): ZStream[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.ResourceInfo.ReadOnly
  ] = ZStream.serviceWithStream(_.listResources(request))
  def listResourcesPaginated(
      request: zio.aws.lakeformation.model.ListResourcesRequest
  ): ZIO[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.ListResourcesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listResourcesPaginated(request))
  def putDataLakeSettings(
      request: zio.aws.lakeformation.model.PutDataLakeSettingsRequest
  ): ZIO[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.PutDataLakeSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putDataLakeSettings(request))
  def deregisterResource(
      request: zio.aws.lakeformation.model.DeregisterResourceRequest
  ): ZIO[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.DeregisterResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deregisterResource(request))
  def getTableObjects(
      request: zio.aws.lakeformation.model.GetTableObjectsRequest
  ): ZStream[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.PartitionObjects.ReadOnly
  ] = ZStream.serviceWithStream(_.getTableObjects(request))
  def getTableObjectsPaginated(
      request: zio.aws.lakeformation.model.GetTableObjectsRequest
  ): ZIO[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.GetTableObjectsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getTableObjectsPaginated(request))
  def createDataCellsFilter(
      request: zio.aws.lakeformation.model.CreateDataCellsFilterRequest
  ): ZIO[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.CreateDataCellsFilterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDataCellsFilter(request))
  def listDataCellsFilter(
      request: zio.aws.lakeformation.model.ListDataCellsFilterRequest
  ): ZStream[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.DataCellsFilter.ReadOnly
  ] = ZStream.serviceWithStream(_.listDataCellsFilter(request))
  def listDataCellsFilterPaginated(
      request: zio.aws.lakeformation.model.ListDataCellsFilterRequest
  ): ZIO[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.ListDataCellsFilterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDataCellsFilterPaginated(request))
  def getTemporaryGlueTableCredentials(
      request: zio.aws.lakeformation.model.GetTemporaryGlueTableCredentialsRequest
  ): ZIO[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.GetTemporaryGlueTableCredentialsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getTemporaryGlueTableCredentials(request))
  def deleteDataCellsFilter(
      request: zio.aws.lakeformation.model.DeleteDataCellsFilterRequest
  ): ZIO[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.DeleteDataCellsFilterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDataCellsFilter(request))
  def listPermissions(
      request: zio.aws.lakeformation.model.ListPermissionsRequest
  ): ZStream[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.PrincipalResourcePermissions.ReadOnly
  ] = ZStream.serviceWithStream(_.listPermissions(request))
  def listPermissionsPaginated(
      request: zio.aws.lakeformation.model.ListPermissionsRequest
  ): ZIO[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.ListPermissionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPermissionsPaginated(request))
  def createLFTag(request: zio.aws.lakeformation.model.CreateLfTagRequest): ZIO[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.CreateLfTagResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createLFTag(request))
  def updateLFTag(request: zio.aws.lakeformation.model.UpdateLfTagRequest): ZIO[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.UpdateLfTagResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateLFTag(request))
  def updateTableStorageOptimizer(
      request: zio.aws.lakeformation.model.UpdateTableStorageOptimizerRequest
  ): ZIO[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.UpdateTableStorageOptimizerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateTableStorageOptimizer(request))
  def getQueryState(
      request: zio.aws.lakeformation.model.GetQueryStateRequest
  ): ZIO[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.GetQueryStateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getQueryState(request))
  def batchGrantPermissions(
      request: zio.aws.lakeformation.model.BatchGrantPermissionsRequest
  ): ZIO[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.BatchGrantPermissionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchGrantPermissions(request))
  def addLFTagsToResource(
      request: zio.aws.lakeformation.model.AddLfTagsToResourceRequest
  ): ZIO[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.AddLfTagsToResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.addLFTagsToResource(request))
  def startTransaction(
      request: zio.aws.lakeformation.model.StartTransactionRequest
  ): ZIO[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.StartTransactionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startTransaction(request))
  def getQueryStatistics(
      request: zio.aws.lakeformation.model.GetQueryStatisticsRequest
  ): ZIO[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.GetQueryStatisticsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getQueryStatistics(request))
  def getLFTag(request: zio.aws.lakeformation.model.GetLfTagRequest): ZIO[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.GetLfTagResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getLFTag(request))
  def registerResource(
      request: zio.aws.lakeformation.model.RegisterResourceRequest
  ): ZIO[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.RegisterResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.registerResource(request))
  def listTableStorageOptimizers(
      request: zio.aws.lakeformation.model.ListTableStorageOptimizersRequest
  ): ZStream[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.StorageOptimizer.ReadOnly
  ] = ZStream.serviceWithStream(_.listTableStorageOptimizers(request))
  def listTableStorageOptimizersPaginated(
      request: zio.aws.lakeformation.model.ListTableStorageOptimizersRequest
  ): ZIO[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.ListTableStorageOptimizersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTableStorageOptimizersPaginated(request))
  def getEffectivePermissionsForPath(
      request: zio.aws.lakeformation.model.GetEffectivePermissionsForPathRequest
  ): ZStream[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.PrincipalResourcePermissions.ReadOnly
  ] = ZStream.serviceWithStream(_.getEffectivePermissionsForPath(request))
  def getEffectivePermissionsForPathPaginated(
      request: zio.aws.lakeformation.model.GetEffectivePermissionsForPathRequest
  ): ZIO[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.GetEffectivePermissionsForPathResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getEffectivePermissionsForPathPaginated(request))
  def batchRevokePermissions(
      request: zio.aws.lakeformation.model.BatchRevokePermissionsRequest
  ): ZIO[
    zio.aws.lakeformation.LakeFormation,
    AwsError,
    zio.aws.lakeformation.model.BatchRevokePermissionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchRevokePermissions(request))
}
