package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.lakeformation.model.primitives.{
  GetWorkUnitsRequestQueryIdString,
  Integer,
  Token
}
import scala.jdk.CollectionConverters._
final case class GetWorkUnitsRequest(
    nextToken: Optional[Token] = Optional.Absent,
    pageSize: Optional[Integer] = Optional.Absent,
    queryId: GetWorkUnitsRequestQueryIdString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.GetWorkUnitsRequest = {
    import GetWorkUnitsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.GetWorkUnitsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(pageSize.map(value => value: java.lang.Integer))(
        _.pageSize
      )
      .queryId(
        GetWorkUnitsRequestQueryIdString.unwrap(queryId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.GetWorkUnitsRequest.ReadOnly =
    zio.aws.lakeformation.model.GetWorkUnitsRequest.wrap(buildAwsValue())
}
object GetWorkUnitsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.GetWorkUnitsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.GetWorkUnitsRequest =
      zio.aws.lakeformation.model.GetWorkUnitsRequest(
        nextToken.map(value => value),
        pageSize.map(value => value),
        queryId
      )
    def nextToken: Optional[Token]
    def pageSize: Optional[Integer]
    def queryId: GetWorkUnitsRequestQueryIdString
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPageSize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("pageSize", pageSize)
    def getQueryId: ZIO[Any, Nothing, GetWorkUnitsRequestQueryIdString] =
      ZIO.succeed(queryId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.GetWorkUnitsRequest
  ) extends zio.aws.lakeformation.model.GetWorkUnitsRequest.ReadOnly {
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lakeformation.model.primitives.Token(value))
    override val pageSize: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.pageSize())
      .map(value => value: Integer)
    override val queryId: GetWorkUnitsRequestQueryIdString =
      zio.aws.lakeformation.model.primitives
        .GetWorkUnitsRequestQueryIdString(impl.queryId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.GetWorkUnitsRequest
  ): zio.aws.lakeformation.model.GetWorkUnitsRequest.ReadOnly = new Wrapper(
    impl
  )
}
