package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.lakeformation.model.primitives.Identifier
import scala.jdk.CollectionConverters._
final case class BatchPermissionsRequestEntry(
    id: Identifier,
    principal: Optional[zio.aws.lakeformation.model.DataLakePrincipal] =
      Optional.Absent,
    resource: Optional[zio.aws.lakeformation.model.Resource] = Optional.Absent,
    permissions: Optional[Iterable[zio.aws.lakeformation.model.Permission]] =
      Optional.Absent,
    permissionsWithGrantOption: Optional[
      Iterable[zio.aws.lakeformation.model.Permission]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.BatchPermissionsRequestEntry = {
    import BatchPermissionsRequestEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.BatchPermissionsRequestEntry
      .builder()
      .id(Identifier.unwrap(id): java.lang.String)
      .optionallyWith(principal.map(value => value.buildAwsValue()))(
        _.principal
      )
      .optionallyWith(resource.map(value => value.buildAwsValue()))(_.resource)
      .optionallyWith(
        permissions.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.permissionsWithStrings)
      .optionallyWith(
        permissionsWithGrantOption.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.permissionsWithGrantOptionWithStrings)
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.BatchPermissionsRequestEntry.ReadOnly =
    zio.aws.lakeformation.model.BatchPermissionsRequestEntry
      .wrap(buildAwsValue())
}
object BatchPermissionsRequestEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.BatchPermissionsRequestEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.BatchPermissionsRequestEntry =
      zio.aws.lakeformation.model.BatchPermissionsRequestEntry(
        id,
        principal.map(value => value.asEditable),
        resource.map(value => value.asEditable),
        permissions.map(value => value),
        permissionsWithGrantOption.map(value => value)
      )
    def id: Identifier
    def principal
        : Optional[zio.aws.lakeformation.model.DataLakePrincipal.ReadOnly]
    def resource: Optional[zio.aws.lakeformation.model.Resource.ReadOnly]
    def permissions: Optional[List[zio.aws.lakeformation.model.Permission]]
    def permissionsWithGrantOption
        : Optional[List[zio.aws.lakeformation.model.Permission]]
    def getId: ZIO[Any, Nothing, Identifier] = ZIO.succeed(id)
    def getPrincipal: ZIO[
      Any,
      AwsError,
      zio.aws.lakeformation.model.DataLakePrincipal.ReadOnly
    ] = AwsError.unwrapOptionField("principal", principal)
    def getResource
        : ZIO[Any, AwsError, zio.aws.lakeformation.model.Resource.ReadOnly] =
      AwsError.unwrapOptionField("resource", resource)
    def getPermissions
        : ZIO[Any, AwsError, List[zio.aws.lakeformation.model.Permission]] =
      AwsError.unwrapOptionField("permissions", permissions)
    def getPermissionsWithGrantOption
        : ZIO[Any, AwsError, List[zio.aws.lakeformation.model.Permission]] =
      AwsError.unwrapOptionField(
        "permissionsWithGrantOption",
        permissionsWithGrantOption
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.BatchPermissionsRequestEntry
  ) extends zio.aws.lakeformation.model.BatchPermissionsRequestEntry.ReadOnly {
    override val id: Identifier =
      zio.aws.lakeformation.model.primitives.Identifier(impl.id())
    override val principal
        : Optional[zio.aws.lakeformation.model.DataLakePrincipal.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.principal())
        .map(value => zio.aws.lakeformation.model.DataLakePrincipal.wrap(value))
    override val resource
        : Optional[zio.aws.lakeformation.model.Resource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resource())
        .map(value => zio.aws.lakeformation.model.Resource.wrap(value))
    override val permissions
        : Optional[List[zio.aws.lakeformation.model.Permission]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.permissions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lakeformation.model.Permission.wrap(item)
          }.toList
        )
    override val permissionsWithGrantOption
        : Optional[List[zio.aws.lakeformation.model.Permission]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.permissionsWithGrantOption())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lakeformation.model.Permission.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.BatchPermissionsRequestEntry
  ): zio.aws.lakeformation.model.BatchPermissionsRequestEntry.ReadOnly =
    new Wrapper(impl)
}
