package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.lakeformation.model.primitives.QueryIdString
import scala.jdk.CollectionConverters._
final case class StartQueryPlanningResponse(queryId: QueryIdString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.StartQueryPlanningResponse = {
    import StartQueryPlanningResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.StartQueryPlanningResponse
      .builder()
      .queryId(QueryIdString.unwrap(queryId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.StartQueryPlanningResponse.ReadOnly =
    zio.aws.lakeformation.model.StartQueryPlanningResponse.wrap(buildAwsValue())
}
object StartQueryPlanningResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.StartQueryPlanningResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.StartQueryPlanningResponse =
      zio.aws.lakeformation.model.StartQueryPlanningResponse(queryId)
    def queryId: QueryIdString
    def getQueryId: ZIO[Any, Nothing, QueryIdString] = ZIO.succeed(queryId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.StartQueryPlanningResponse
  ) extends zio.aws.lakeformation.model.StartQueryPlanningResponse.ReadOnly {
    override val queryId: QueryIdString =
      zio.aws.lakeformation.model.primitives.QueryIdString(impl.queryId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.StartQueryPlanningResponse
  ): zio.aws.lakeformation.model.StartQueryPlanningResponse.ReadOnly =
    new Wrapper(impl)
}
