package zio.aws.lakeformation.model
import zio.aws.lakeformation.model.primitives.{
  Token,
  PageSize,
  NameString,
  CatalogIdString
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListTableStorageOptimizersRequest(
    catalogId: Optional[CatalogIdString] = Optional.Absent,
    databaseName: NameString,
    tableName: NameString,
    storageOptimizerType: Optional[zio.aws.lakeformation.model.OptimizerType] =
      Optional.Absent,
    maxResults: Optional[PageSize] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.ListTableStorageOptimizersRequest = {
    import ListTableStorageOptimizersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.ListTableStorageOptimizersRequest
      .builder()
      .optionallyWith(
        catalogId.map(value => CatalogIdString.unwrap(value): java.lang.String)
      )(_.catalogId)
      .databaseName(NameString.unwrap(databaseName): java.lang.String)
      .tableName(NameString.unwrap(tableName): java.lang.String)
      .optionallyWith(storageOptimizerType.map(value => value.unwrap))(
        _.storageOptimizerType
      )
      .optionallyWith(maxResults.map(value => PageSize.unwrap(value): Integer))(
        _.maxResults
      )
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.ListTableStorageOptimizersRequest.ReadOnly =
    zio.aws.lakeformation.model.ListTableStorageOptimizersRequest
      .wrap(buildAwsValue())
}
object ListTableStorageOptimizersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.ListTableStorageOptimizersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lakeformation.model.ListTableStorageOptimizersRequest =
      zio.aws.lakeformation.model.ListTableStorageOptimizersRequest(
        catalogId.map(value => value),
        databaseName,
        tableName,
        storageOptimizerType.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def catalogId: Optional[CatalogIdString]
    def databaseName: NameString
    def tableName: NameString
    def storageOptimizerType
        : Optional[zio.aws.lakeformation.model.OptimizerType]
    def maxResults: Optional[PageSize]
    def nextToken: Optional[Token]
    def getCatalogId: ZIO[Any, AwsError, CatalogIdString] =
      AwsError.unwrapOptionField("catalogId", catalogId)
    def getDatabaseName: ZIO[Any, Nothing, NameString] =
      ZIO.succeed(databaseName)
    def getTableName: ZIO[Any, Nothing, NameString] = ZIO.succeed(tableName)
    def getStorageOptimizerType
        : ZIO[Any, AwsError, zio.aws.lakeformation.model.OptimizerType] =
      AwsError.unwrapOptionField("storageOptimizerType", storageOptimizerType)
    def getMaxResults: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.ListTableStorageOptimizersRequest
  ) extends zio.aws.lakeformation.model.ListTableStorageOptimizersRequest.ReadOnly {
    override val catalogId: Optional[CatalogIdString] = zio.aws.core.internal
      .optionalFromNullable(impl.catalogId())
      .map(value =>
        zio.aws.lakeformation.model.primitives.CatalogIdString(value)
      )
    override val databaseName: NameString =
      zio.aws.lakeformation.model.primitives.NameString(impl.databaseName())
    override val tableName: NameString =
      zio.aws.lakeformation.model.primitives.NameString(impl.tableName())
    override val storageOptimizerType
        : Optional[zio.aws.lakeformation.model.OptimizerType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageOptimizerType())
        .map(value => zio.aws.lakeformation.model.OptimizerType.wrap(value))
    override val maxResults: Optional[PageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.lakeformation.model.primitives.PageSize(value))
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lakeformation.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.ListTableStorageOptimizersRequest
  ): zio.aws.lakeformation.model.ListTableStorageOptimizersRequest.ReadOnly =
    new Wrapper(impl)
}
