package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.lakeformation.model.primitives.Token
import scala.jdk.CollectionConverters._
final case class ListDataCellsFilterResponse(
    dataCellsFilters: Optional[
      Iterable[zio.aws.lakeformation.model.DataCellsFilter]
    ] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.ListDataCellsFilterResponse = {
    import ListDataCellsFilterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.ListDataCellsFilterResponse
      .builder()
      .optionallyWith(
        dataCellsFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dataCellsFilters)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.ListDataCellsFilterResponse.ReadOnly =
    zio.aws.lakeformation.model.ListDataCellsFilterResponse
      .wrap(buildAwsValue())
}
object ListDataCellsFilterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.ListDataCellsFilterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.ListDataCellsFilterResponse =
      zio.aws.lakeformation.model.ListDataCellsFilterResponse(
        dataCellsFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def dataCellsFilters
        : Optional[List[zio.aws.lakeformation.model.DataCellsFilter.ReadOnly]]
    def nextToken: Optional[Token]
    def getDataCellsFilters: ZIO[Any, AwsError, List[
      zio.aws.lakeformation.model.DataCellsFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("dataCellsFilters", dataCellsFilters)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.ListDataCellsFilterResponse
  ) extends zio.aws.lakeformation.model.ListDataCellsFilterResponse.ReadOnly {
    override val dataCellsFilters
        : Optional[List[zio.aws.lakeformation.model.DataCellsFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataCellsFilters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lakeformation.model.DataCellsFilter.wrap(item)
          }.toList
        )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lakeformation.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.ListDataCellsFilterResponse
  ): zio.aws.lakeformation.model.ListDataCellsFilterResponse.ReadOnly =
    new Wrapper(impl)
}
