package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.lakeformation.model.primitives.{
  PartitionValueString,
  ETagString,
  URI
}
import scala.jdk.CollectionConverters._
final case class DeleteObjectInput(
    uri: URI,
    eTag: Optional[ETagString] = Optional.Absent,
    partitionValues: Optional[Iterable[PartitionValueString]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.DeleteObjectInput = {
    import DeleteObjectInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.DeleteObjectInput
      .builder()
      .uri(URI.unwrap(uri): java.lang.String)
      .optionallyWith(
        eTag.map(value => ETagString.unwrap(value): java.lang.String)
      )(_.eTag)
      .optionallyWith(
        partitionValues.map(value =>
          value.map { item =>
            PartitionValueString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.partitionValues)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.DeleteObjectInput.ReadOnly =
    zio.aws.lakeformation.model.DeleteObjectInput.wrap(buildAwsValue())
}
object DeleteObjectInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.DeleteObjectInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.DeleteObjectInput =
      zio.aws.lakeformation.model.DeleteObjectInput(
        uri,
        eTag.map(value => value),
        partitionValues.map(value => value)
      )
    def uri: URI
    def eTag: Optional[ETagString]
    def partitionValues: Optional[List[PartitionValueString]]
    def getUri: ZIO[Any, Nothing, URI] = ZIO.succeed(uri)
    def getETag: ZIO[Any, AwsError, ETagString] =
      AwsError.unwrapOptionField("eTag", eTag)
    def getPartitionValues: ZIO[Any, AwsError, List[PartitionValueString]] =
      AwsError.unwrapOptionField("partitionValues", partitionValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.DeleteObjectInput
  ) extends zio.aws.lakeformation.model.DeleteObjectInput.ReadOnly {
    override val uri: URI =
      zio.aws.lakeformation.model.primitives.URI(impl.uri())
    override val eTag: Optional[ETagString] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => zio.aws.lakeformation.model.primitives.ETagString(value))
    override val partitionValues: Optional[List[PartitionValueString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.partitionValues())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lakeformation.model.primitives.PartitionValueString(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.DeleteObjectInput
  ): zio.aws.lakeformation.model.DeleteObjectInput.ReadOnly = new Wrapper(impl)
}
