package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.lakeformation.model.primitives.TokenString
import scala.jdk.CollectionConverters._
final case class ListTransactionsResponse(
    transactions: Optional[
      Iterable[zio.aws.lakeformation.model.TransactionDescription]
    ] = Optional.Absent,
    nextToken: Optional[TokenString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.ListTransactionsResponse = {
    import ListTransactionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.ListTransactionsResponse
      .builder()
      .optionallyWith(
        transactions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.transactions)
      .optionallyWith(
        nextToken.map(value => TokenString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.ListTransactionsResponse.ReadOnly =
    zio.aws.lakeformation.model.ListTransactionsResponse.wrap(buildAwsValue())
}
object ListTransactionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.ListTransactionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.ListTransactionsResponse =
      zio.aws.lakeformation.model.ListTransactionsResponse(
        transactions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def transactions: Optional[
      List[zio.aws.lakeformation.model.TransactionDescription.ReadOnly]
    ]
    def nextToken: Optional[TokenString]
    def getTransactions: ZIO[Any, AwsError, List[
      zio.aws.lakeformation.model.TransactionDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("transactions", transactions)
    def getNextToken: ZIO[Any, AwsError, TokenString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.ListTransactionsResponse
  ) extends zio.aws.lakeformation.model.ListTransactionsResponse.ReadOnly {
    override val transactions: Optional[
      List[zio.aws.lakeformation.model.TransactionDescription.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.transactions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lakeformation.model.TransactionDescription.wrap(item)
        }.toList
      )
    override val nextToken: Optional[TokenString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lakeformation.model.primitives.TokenString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.ListTransactionsResponse
  ): zio.aws.lakeformation.model.ListTransactionsResponse.ReadOnly =
    new Wrapper(impl)
}
