package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.lakeformation.model.primitives.CatalogIdString
import scala.jdk.CollectionConverters._
final case class LFTagPolicyResource(
    catalogId: Optional[CatalogIdString] = Optional.Absent,
    resourceType: zio.aws.lakeformation.model.ResourceType,
    expression: Iterable[zio.aws.lakeformation.model.LFTag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.LFTagPolicyResource = {
    import LFTagPolicyResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.LFTagPolicyResource
      .builder()
      .optionallyWith(
        catalogId.map(value => CatalogIdString.unwrap(value): java.lang.String)
      )(_.catalogId)
      .resourceType(resourceType.unwrap)
      .expression(expression.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.LFTagPolicyResource.ReadOnly =
    zio.aws.lakeformation.model.LFTagPolicyResource.wrap(buildAwsValue())
}
object LFTagPolicyResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.LFTagPolicyResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.LFTagPolicyResource =
      zio.aws.lakeformation.model.LFTagPolicyResource(
        catalogId.map(value => value),
        resourceType,
        expression.map { item =>
          item.asEditable
        }
      )
    def catalogId: Optional[CatalogIdString]
    def resourceType: zio.aws.lakeformation.model.ResourceType
    def expression: List[zio.aws.lakeformation.model.LFTag.ReadOnly]
    def getCatalogId: ZIO[Any, AwsError, CatalogIdString] =
      AwsError.unwrapOptionField("catalogId", catalogId)
    def getResourceType
        : ZIO[Any, Nothing, zio.aws.lakeformation.model.ResourceType] =
      ZIO.succeed(resourceType)
    def getExpression
        : ZIO[Any, Nothing, List[zio.aws.lakeformation.model.LFTag.ReadOnly]] =
      ZIO.succeed(expression)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.LFTagPolicyResource
  ) extends zio.aws.lakeformation.model.LFTagPolicyResource.ReadOnly {
    override val catalogId: Optional[CatalogIdString] = zio.aws.core.internal
      .optionalFromNullable(impl.catalogId())
      .map(value =>
        zio.aws.lakeformation.model.primitives.CatalogIdString(value)
      )
    override val resourceType: zio.aws.lakeformation.model.ResourceType =
      zio.aws.lakeformation.model.ResourceType.wrap(impl.resourceType())
    override val expression: List[zio.aws.lakeformation.model.LFTag.ReadOnly] =
      impl
        .expression()
        .asScala
        .map { item =>
          zio.aws.lakeformation.model.LFTag.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.LFTagPolicyResource
  ): zio.aws.lakeformation.model.LFTagPolicyResource.ReadOnly = new Wrapper(
    impl
  )
}
