package zio.aws.lakeformation.model
import zio.aws.lakeformation.model.primitives.DateTime
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetQueryStatisticsResponse(
    executionStatistics: Optional[
      zio.aws.lakeformation.model.ExecutionStatistics
    ] = Optional.Absent,
    planningStatistics: Optional[
      zio.aws.lakeformation.model.PlanningStatistics
    ] = Optional.Absent,
    querySubmissionTime: Optional[DateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.GetQueryStatisticsResponse = {
    import GetQueryStatisticsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.GetQueryStatisticsResponse
      .builder()
      .optionallyWith(executionStatistics.map(value => value.buildAwsValue()))(
        _.executionStatistics
      )
      .optionallyWith(planningStatistics.map(value => value.buildAwsValue()))(
        _.planningStatistics
      )
      .optionallyWith(
        querySubmissionTime.map(value => DateTime.unwrap(value): Instant)
      )(_.querySubmissionTime)
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.GetQueryStatisticsResponse.ReadOnly =
    zio.aws.lakeformation.model.GetQueryStatisticsResponse.wrap(buildAwsValue())
}
object GetQueryStatisticsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.GetQueryStatisticsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.GetQueryStatisticsResponse =
      zio.aws.lakeformation.model.GetQueryStatisticsResponse(
        executionStatistics.map(value => value.asEditable),
        planningStatistics.map(value => value.asEditable),
        querySubmissionTime.map(value => value)
      )
    def executionStatistics
        : Optional[zio.aws.lakeformation.model.ExecutionStatistics.ReadOnly]
    def planningStatistics
        : Optional[zio.aws.lakeformation.model.PlanningStatistics.ReadOnly]
    def querySubmissionTime: Optional[DateTime]
    def getExecutionStatistics: ZIO[
      Any,
      AwsError,
      zio.aws.lakeformation.model.ExecutionStatistics.ReadOnly
    ] = AwsError.unwrapOptionField("executionStatistics", executionStatistics)
    def getPlanningStatistics: ZIO[
      Any,
      AwsError,
      zio.aws.lakeformation.model.PlanningStatistics.ReadOnly
    ] = AwsError.unwrapOptionField("planningStatistics", planningStatistics)
    def getQuerySubmissionTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("querySubmissionTime", querySubmissionTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.GetQueryStatisticsResponse
  ) extends zio.aws.lakeformation.model.GetQueryStatisticsResponse.ReadOnly {
    override val executionStatistics
        : Optional[zio.aws.lakeformation.model.ExecutionStatistics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionStatistics())
        .map(value =>
          zio.aws.lakeformation.model.ExecutionStatistics.wrap(value)
        )
    override val planningStatistics
        : Optional[zio.aws.lakeformation.model.PlanningStatistics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.planningStatistics())
        .map(value =>
          zio.aws.lakeformation.model.PlanningStatistics.wrap(value)
        )
    override val querySubmissionTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.querySubmissionTime())
      .map(value => zio.aws.lakeformation.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.GetQueryStatisticsResponse
  ): zio.aws.lakeformation.model.GetQueryStatisticsResponse.ReadOnly =
    new Wrapper(impl)
}
