package zio.aws.lakeformation.model
import scala.jdk.CollectionConverters._
sealed trait FieldNameString {
  def unwrap
      : software.amazon.awssdk.services.lakeformation.model.FieldNameString
}
object FieldNameString {
  def wrap(
      value: software.amazon.awssdk.services.lakeformation.model.FieldNameString
  ): zio.aws.lakeformation.model.FieldNameString = value match {
    case software.amazon.awssdk.services.lakeformation.model.FieldNameString.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lakeformation.model.FieldNameString.RESOURCE_ARN =>
      val r = RESOURCE_ARN
      r
    case software.amazon.awssdk.services.lakeformation.model.FieldNameString.ROLE_ARN =>
      val r = ROLE_ARN
      r
    case software.amazon.awssdk.services.lakeformation.model.FieldNameString.LAST_MODIFIED =>
      val r = LAST_MODIFIED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lakeformation.model.FieldNameString {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.FieldNameString =
      software.amazon.awssdk.services.lakeformation.model.FieldNameString.UNKNOWN_TO_SDK_VERSION
  }
  case object RESOURCE_ARN extends zio.aws.lakeformation.model.FieldNameString {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.FieldNameString =
      software.amazon.awssdk.services.lakeformation.model.FieldNameString.RESOURCE_ARN
  }
  case object ROLE_ARN extends zio.aws.lakeformation.model.FieldNameString {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.FieldNameString =
      software.amazon.awssdk.services.lakeformation.model.FieldNameString.ROLE_ARN
  }
  case object LAST_MODIFIED
      extends zio.aws.lakeformation.model.FieldNameString {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.FieldNameString =
      software.amazon.awssdk.services.lakeformation.model.FieldNameString.LAST_MODIFIED
  }
}
