package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.lakeformation.model.primitives.ResourceArnString
import scala.jdk.CollectionConverters._
final case class DeregisterResourceRequest(resourceArn: ResourceArnString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.DeregisterResourceRequest = {
    import DeregisterResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.DeregisterResourceRequest
      .builder()
      .resourceArn(ResourceArnString.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.DeregisterResourceRequest.ReadOnly =
    zio.aws.lakeformation.model.DeregisterResourceRequest.wrap(buildAwsValue())
}
object DeregisterResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.DeregisterResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.DeregisterResourceRequest =
      zio.aws.lakeformation.model.DeregisterResourceRequest(resourceArn)
    def resourceArn: ResourceArnString
    def getResourceArn: ZIO[Any, Nothing, ResourceArnString] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.DeregisterResourceRequest
  ) extends zio.aws.lakeformation.model.DeregisterResourceRequest.ReadOnly {
    override val resourceArn: ResourceArnString =
      zio.aws.lakeformation.model.primitives
        .ResourceArnString(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.DeregisterResourceRequest
  ): zio.aws.lakeformation.model.DeregisterResourceRequest.ReadOnly =
    new Wrapper(impl)
}
