package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.lakeformation.model.primitives.NameString
import scala.jdk.CollectionConverters._
final case class ColumnLFTag(
    name: Optional[NameString] = Optional.Absent,
    lfTags: Optional[Iterable[zio.aws.lakeformation.model.LFTagPair]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.ColumnLFTag = {
    import ColumnLFTag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.ColumnLFTag
      .builder()
      .optionallyWith(
        name.map(value => NameString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        lfTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lfTags)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.ColumnLFTag.ReadOnly =
    zio.aws.lakeformation.model.ColumnLFTag.wrap(buildAwsValue())
}
object ColumnLFTag {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.ColumnLFTag
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.ColumnLFTag =
      zio.aws.lakeformation.model.ColumnLFTag(
        name.map(value => value),
        lfTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: Optional[NameString]
    def lfTags: Optional[List[zio.aws.lakeformation.model.LFTagPair.ReadOnly]]
    def getName: ZIO[Any, AwsError, NameString] =
      AwsError.unwrapOptionField("name", name)
    def getLfTags: ZIO[Any, AwsError, List[
      zio.aws.lakeformation.model.LFTagPair.ReadOnly
    ]] = AwsError.unwrapOptionField("lfTags", lfTags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.ColumnLFTag
  ) extends zio.aws.lakeformation.model.ColumnLFTag.ReadOnly {
    override val name: Optional[NameString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.lakeformation.model.primitives.NameString(value))
    override val lfTags
        : Optional[List[zio.aws.lakeformation.model.LFTagPair.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lfTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lakeformation.model.LFTagPair.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.ColumnLFTag
  ): zio.aws.lakeformation.model.ColumnLFTag.ReadOnly = new Wrapper(impl)
}
