package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.lakeformation.model.primitives.Result
import scala.jdk.CollectionConverters._
final case class UpdateTableStorageOptimizerResponse(
    result: Optional[Result] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.UpdateTableStorageOptimizerResponse = {
    import UpdateTableStorageOptimizerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.UpdateTableStorageOptimizerResponse
      .builder()
      .optionallyWith(
        result.map(value => Result.unwrap(value): java.lang.String)
      )(_.result)
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.UpdateTableStorageOptimizerResponse.ReadOnly =
    zio.aws.lakeformation.model.UpdateTableStorageOptimizerResponse
      .wrap(buildAwsValue())
}
object UpdateTableStorageOptimizerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.UpdateTableStorageOptimizerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lakeformation.model.UpdateTableStorageOptimizerResponse =
      zio.aws.lakeformation.model
        .UpdateTableStorageOptimizerResponse(result.map(value => value))
    def result: Optional[Result]
    def getResult: ZIO[Any, AwsError, Result] =
      AwsError.unwrapOptionField("result", result)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.UpdateTableStorageOptimizerResponse
  ) extends zio.aws.lakeformation.model.UpdateTableStorageOptimizerResponse.ReadOnly {
    override val result: Optional[Result] = zio.aws.core.internal
      .optionalFromNullable(impl.result())
      .map(value => zio.aws.lakeformation.model.primitives.Result(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.UpdateTableStorageOptimizerResponse
  ): zio.aws.lakeformation.model.UpdateTableStorageOptimizerResponse.ReadOnly =
    new Wrapper(impl)
}
